package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.api.dto.GrayTenantDTO;
import com.digiwin.athena.aim.api.dto.TenantRouteDTO;
import com.digiwin.athena.aim.common.TenantRouteTypeEnum;
import com.digiwin.athena.aim.domain.message.model.TenantRouteChangeMessageDO;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.aim.domain.tenantroute.service.TenantRouteService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/10/25 15:32
 */
@RestController
@RequestMapping(value = "/api/aim/v1/tenant/route")
public class TenantRouteController {

    private final TenantRouteService tenantRouteService;

    private final MessageSendService messageSendService;

    public TenantRouteController(TenantRouteService tenantRouteService, MessageSendService messageSendService) {
        this.tenantRouteService = tenantRouteService;
        this.messageSendService = messageSendService;
    }

    /**
     * @param
     * @return
     * @description: 查询组件的所有的预区的租户集合<br></>
     * 这个函数不适配金丝雀环境
     * @author: sunyfa
     */
    @GetMapping("/queryPreEnvTenantIdList")
    public ResponseEntity queryPreEnvTenantIdList(@RequestParam(value = "app") String app) {
        List<String> preEnvTenantIdList = tenantRouteService.queryPreEnvTenantIdList(app);
        return ResponseEntityWrapper.wrapperOk(preEnvTenantIdList);
    }

    /**
     * 根据不同环境获取对应的租户列表
     * 最新的获取不同mode环境对应的租户列表<br></>
     * 注意: 这里的mode是指不同的环境，如：pre、canary、prod,只有prod是返回序列剔除的租户列表，其他返回自己对应的列表
     *
     * @param app
     * @param mode
     * @return
     */
    @GetMapping("/queryResolveEnvTenantIdList")
    public ResponseEntity queryResolveEnvTenantIdList(@RequestParam(value = "app") String app, @RequestParam(value = "mode") String mode) {
        GrayTenantDTO grayTenantDTO = tenantRouteService.queryResolveEnvTenantIdList(app, mode);
        return ResponseEntityWrapper.wrapperOk(grayTenantDTO);
    }

    @GetMapping("/getType")
    public ResponseEntity queryAllCollectionInfo(@RequestParam(value = "app") String app) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Pair<TenantRouteTypeEnum, String> routeType = tenantRouteService.getRouteType(tenantId, app);
        return ResponseEntityWrapper.wrapperOk(routeType.getLeft().name());
    }

    @GetMapping("/batchGetType")
    public ResponseEntity batchQueryAllCollectionInfo(@RequestParam(value = "apps") String apps) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        String[] appArr = StringUtils.split(apps, ",");
        Map<String, String> routeTypeMap = new HashMap<>();
        for (String app : appArr) {
            Pair<TenantRouteTypeEnum, String> routeType = tenantRouteService.getRouteType(tenantId, app);
            routeTypeMap.put(app, routeType.getLeft().name());
        }
        return ResponseEntityWrapper.wrapperOk(routeTypeMap);
    }

    @PostMapping("/sendChange")
    public ResponseEntity sendChange(@RequestBody TenantRouteDTO tenantRouteDTO) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        if (!StringUtils.equals(tenantRouteDTO.getTenantId(), tenantId)) {
            return ResponseEntityWrapper.wrapperFail(500, "tenantId not match token");
        }
        TenantRouteChangeMessageDO messageDO = new TenantRouteChangeMessageDO(tenantRouteDTO.getTenantId(), tenantRouteDTO.getType());
        messageSendService.sendTenantRouteChange(tenantId, tenantRouteDTO.getApp(), messageDO);
        return ResponseEntityWrapper.wrapperOk("success");
    }
}
