package com.digiwin.athena.aim.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * AppExpireChangeDTO Description
 *
 * @author majianfu
 * @date 2022/8/19
 * @since
 */
@Data
public class AppExpireChangeDTO implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 事件类型，renew:租户续约  expire：刚过期  clean：60天缓冲期过后
     */
    private String eventType;

    /**
     * 应用编号
     */
    private String appCode;

    @Override
    public String toString() {
        return tenantId + "-" + appCode + "-" + eventType;
    }
}
