package com.digiwin.athena.aim.api.dto;

import lombok.Data;
import lombok.ToString;

/**
 * MessagePagingQryCommand Description
 *
 * @author majianfu
 * @date 2021/4/25
 * @since
 */
@Data
@ToString(callSuper = true)
public class MessagePagingQryCommand extends Page {
    /**
     * 消息类型，如：项目：TASK；任务：ACTIVITY
     */
    private String type;

    /**
     * 消息子类型，如：交期回复异常排除：checkConfirmDeliveryDateSolveProblem
     */
    private String subType;

    /**
     * 消息子类型所属类别，如：项目异常/逾期提醒
     */
    private String subTypeCategory;

    /**
     * 消息类别，多个消息类别以英文逗号隔开，如：NEW,EMERGENCY
     */
    private String category;

    /**
     * 重要性，0：不重要，1：重要
     */
    private Integer importance;

    /**
     * 来源，如“athena”
     */
    private String source;

    /**
     * 消息状态，消息状态，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;

    /**
     * 是否过滤非终止消息 ture: 过滤, false: 不过滤
     */
    private Boolean unterminate = false;

    /**
     * 查询的开始时间
     */
    private String startTimeStr;

    /**
     * 查询的结束时间
     */
    private String endTimeStr;

    /**
     * 搜索关键词
     */
    private String key;


    /**
     * 渠道类型  web  app
     */
    private String channelType;
}
