package com.digiwin.athena.aim.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

/**
 * Page Description
 *
 * @author majianfu
 * @date 2021/4/25
 * @since
 */
@Data
public class Page {
    /**
     * 页码
     */
    private Integer pageNum;

    /**
     * 页大小
     */
    private Integer pageSize;

    /**
     * 总页数
     */
    private Integer pageCount;

    /**
     * 查询的总笔数
     */
    private Integer totalCount;

    /**
     * 总的笔数
     */
    private Integer allCount;


    @JsonIgnore
    public int getSkip(){
        return pageNum * pageSize;
    }
}
