package com.digiwin.athena.aim.app.auth;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order
public class CheckTenantAspect {
    @Pointcut("execution(* com.digiwin.athena.aim.api.MessageController.*(..)) ||" +
            "execution(* com.digiwin.athena.aim.api.MessageControllerV2.*(..))")
    public void declarePointcut() {
    }

    @Around("declarePointcut()")
    public Object checkTenant(ProceedingJoinPoint joinPoint) throws Throwable {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (null != authoredUser && StringUtils.isNotBlank(authoredUser.getTenantId())) {
            return joinPoint.proceed();
        } else {
            // 无有效租户ID，直接返回 status == 200;
            return ResponseEntityWrapper.wrapperOk();
//            throw ErrorCodeEnum.TENANT_ID_NOT_FOUND.getBusinessException();
        }
    }
}
