package com.digiwin.athena.aim.app.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
public class MongoTemplateConfig {
    @Value("${spring.data.mongodb-message.uri}")
    private String uriMsg;

    @Value("${spring.data.mongodb-message.database}")
    private String databaseMsg;

    @Value("${spring.data.mongodb.uri}")
    private String uriLog;

    @Value("${spring.data.mongodb.database}")
    private String databaseLog;

    @Bean("msgMongoTemplate")
    public MongoTemplate tagMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriMsg)).build(), null);
        MongoTemplate msgMongoTemplate = new MongoTemplate(client, databaseMsg);
        MongoConverter converter = msgMongoTemplate.getConverter();
        // 去掉_class属性
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter) converter).setTypeMapper(new DefaultMongoTypeMapper(null));
        }

        return msgMongoTemplate;
    }

    @Bean("mongoTemplate")
    public MongoTemplate mongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriLog)).build(), null);
        return new MongoTemplate(client, databaseLog);
    }
}
