package com.digiwin.athena.aim.app.config;

import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.athena.aim.domain.message.subscriber.ApolloConfigChangeSubscriber;
import com.digiwin.athena.aim.domain.tenantroute.service.TenantRouteService;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/11/7 12:19
 */
@Slf4j
@Component
public class TenantRouteNamepspaceConfig {

    @Value("${tenantRouteNamespaceConfig:}")
    private String tenantRouteNamespaceConfig;

    private Map<String, String> deployMmcIdMap = new HashMap<>();

    private Map<String, String> deployArKeyMap = new HashMap<>();

    private Map<String, String> deployTrnamespaceMap = new HashMap<>();

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank(tenantRouteNamespaceConfig)) {
            log.warn("租户路由apollo配置中心namespace未配置");
            return;
        }
        Map<String, String> nameSpaceConfig = JsonUtils.jsonToObject(tenantRouteNamespaceConfig, Map.class);
        deployTrnamespaceMap.putAll(nameSpaceConfig);
        nameSpaceConfig.forEach((deployId, trNamespace) -> {
            String mmcId = StringUtils.substringBefore(trNamespace, TenantRouteService.NAMESPACE_SPLITOR);
            deployMmcIdMap.put(deployId, mmcId);
            String arKey = StringUtils.substringAfter(trNamespace, TenantRouteService.NAMESPACE_SPLITOR);
            arKey = StringUtils.substringBeforeLast(arKey, TenantRouteService.TR_NAMESPACE_SUFFIX);
            deployArKeyMap.put(deployId, arKey);
            ApolloConfigChangeSubscriber handler = new ApolloConfigChangeSubscriber(deployId);
            ConfigService.getConfig(trNamespace).addChangeListener(handler);
        });
    }

    public String getMmcIdByDeployId(String deployId) {
        return deployMmcIdMap.get(deployId);
    }

    public String getArKeyByDeployId(String deployId) {
        return deployArKeyMap.get(deployId);
    }
}
