package com.digiwin.athena.aim.app.env;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author yanyn
 */
@RestController
@RequestMapping
public class EnvController {

    @Autowired
    EnvProperties envProperties;

    @Resource
    protected MongoTemplate msgMongoTemplate;

    /**
     * 返回环境参数
     */
    @GetMapping(value = {"/api/env"}, produces = "application/json; charset=utf-8")
    public ResponseEntity<?> getRuntimeEnv() {
        envProperties.refresh();
        return ResponseEntity.ok(envProperties);
    }

    /**
     * 测试mongo
     */
    @GetMapping(value = {"/api/env/test/mongo"}, produces = "application/json; charset=utf-8")
    public ResponseEntity<?> testMongo() {

        Query query = Query.query(Criteria.where("tenantId").is("WFATHENA")).limit(1);
        Object o = msgMongoTemplate.find(query, Map.class, "WFATHENA-message-collection");

        return ResponseEntity.ok("OK");
    }
}
