package com.digiwin.athena.aim.common;


/**
 * 常量类
 *
 * @author sungqz
 * @since 2023-11-17
 */
public interface Constants {

    /**
     * 调用来源标识 1：PC端
     */
    public static final Integer INVOKE_PLATFORM_FLAG = 1;

    /**
     * 简体
     */
    public static final String ZH_CN_LOCALE = "zh_CN";

    /**
     * 繁体
     */
    public static final String ZH_TW_LOCALE = "zh_TW";

    /**
     * 英文
     */
    public static final String EN_US_LOCALE = "en_US";

    /**
     * 发送钉钉时KM的应用信息缓存中有效时间7天
     */
    public static final Integer APP_CODE_VALIDITY = 7;

    /**
     * 任务卡详情地址，pc前端地址
     * /task/detail/370488915116096?shareCode=rPqQNBCRdE0mCJ2
     * 370488915116096 任务id
     */
    public static final String TASK_DETAIL_SHARE = "task/detail/%s?shareCode=%s";


    /**
     * 任务卡详情地址，pc前端地址
     * /task/detail/370488915116096?shareCode=rPqQNBCRdE0mCJ2
     * 370488915116096 任务id
     */
    public static final String TASK_DETAIL_NO_SHARECODE = "/task/detail/";


    /**
     * 项目卡详情地址，前端地址
     * /project/share/370465551900736/BRV1jMNof6KKu0Y?engineType=TaskEngine
     * 370465551900736 任务id
     * BRV1jMNof6KKu0Y 分享code
     */
    public static final String PROJECT_TASK_DETAIL = "/project/share/%s/%s?engineType=TaskEngine";

    /**
     * 推送消息项目卡消息类型
     */
    public static final String MESSAGE_TYPE_TASK = "task";

    /**
     * 推送消息任务中的任务催办类型
     */
    public static final String MESSAGE_TYPE_TASK_REMINDER = "reminder";


    /**
     * 推送消息时任务卡消息类型
     */
    public static final String MESSAGE_TYPE_ACTIVITY = "activity";

    /**
     * 推送消息时任务卡消息类型
     */
    public static final String MESSAGE_TYPE_TEXT = "text";

    /**
     * 获取分享code时 项目卡
     */
    public static final String MESSAGE_TYPE_SHARE_PROJECT = "project";

    /**
     * 推送钉钉消息pc端url
     */
    public static final String MESSAGE_DINGTALK_URL = "%s/login/dingtalk-login?appId=%s&corpId=%s&dingLog=0&routerLink=";

    /**
     * 推送钉钉消息app端 url
     */
    public static final String MESSAGE_DINGTALK_APP_URL = "%s/#/?appId=%s&appName=%s&corpId=%s&sourceType=ding_talk&dataId=%s&targetTenantId=%s";

    /**
     * 娜娜推送企微消息url
     */
    public static final String NANA_MESSAGE_PC_URL = "%s/ania/router/routingDistribution";

    /**
     * 娜娜推送钉钉消息url
     */
    public static final String NANA_DINGDINGD_MESSAGE_PC_URL = "%s/ania/dingrouter/routingDistribution";

    /**
     * 娜娜企微推送消息跳转url
     */
    public static final String NANA_REDIRECT_URL = "redirectUrl=%s&tenantId=%s&userId=%s&nanaParams=%s";

    /**
     * 娜娜钉钉推送消息跳转url
     */
    public static final String NANA_REDIRECT_URL_DINGDING = "tenantId=%s&userId=%s&nanaParams=%s";

    /**
     * 敏数推送消息跳转url
     */
    public static final String METRIC_REDIRECT_URL = "redirectUrl=%s&tenantId=%s&userId=%s&nanaParams=%s&question=%s&snapshotId=%s&sendDate=%s&undeletable=%s&dataTipMessage=%s&method=%s&metricIdList=%s";

    /**
     * 娜娜推送钉钉消息pc端url
     */
    //public static final String NANA_MESSAGE_DINGTALK_URL = "%s/login/dingtalk-login?appId=%s&corpId=ding7472b21f3d0afc9cee0f45d8e4f7c288&dingLog=2&%s";
    public static final String NANA_MESSAGE_DINGTALK_URL = "appId=%s&corpId=%s&dingLog=2";

    /**
     * 推送钉钉消息app端 url
     */
    public static final String NANA_MESSAGE_DINGTALK_APP_URL = "%s/#/?NANA=%s";

    /**
     * 消息发送渠道 企微
     */
    public static final String MESSAGE_TYPE_WECOM = "wecom";

    /**
     * 配置有效状态-有效
     */
    public static final Integer VALID_STATUS_ENABLE = 1;

    /**
     * 配置有效状态-无效
     */
    public static final Integer VALID_STATUS_UNUSABLE = 0;

    /**
     * 黑名单标识
     */
    public static final Integer BLACK_TYPE = 0;

    /**
     * 白名单标识
     */
    public static final Integer WHITE_TYPE = 1;

    /**
     * 智能入口appId，也是智能入口在文档中心的Bucket
     */
    public static final String INTELLIGENTENTRY_APP_ID = "intelligententry";

    /**
     * 雅典娜_智能入口消息默认事件
     */
    public static final String SEMC_MESSAGE_DEFAULT_EVENT_ID = "ATHENA_SEMC_MESSAGE_DEFAULT";
}
