package com.digiwin.athena.aim.domain.message.model;

import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;
import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

@Data
@NoArgsConstructor
public class AppExpireMessageDO {

    /**
     * 主键id
     */
    private String gid;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    @NotBlank
    private String tenantId;

    /**
     * 消息内容
     */
    private JSONObject content;

    /**
     * 消息过期时间
     */
    private LocalDateTime endTime;

    /**
     * 应用code
     */
    @NotBlank
    private String appCode;

    /**
     * 消息模板
     */
    private TemplateVariableDTO template;

    /**
     * 创建时间
     */
    private LocalDateTime createDate;

    /**
     * 更新时间
     */
    private LocalDateTime modifyDate;
}
