package com.digiwin.athena.aim.domain.message.model;

import java.util.Calendar;

public abstract class CiConstant {
    public static final int DEFAULT_PAGE_NUM = 0;

    public static final int DEFAULT_PAGE_SIZE = 50;

    public interface Schedule {
        // message config加载周期，1小时
        long MSG_CONFIG_LOAD_SCHEDULE_MILL_SECONDS = 3600 * 1000L;
    }

    public interface Message {
        // 查询最大时间区间---3个月
        int QRY_TIME_UNIT = Calendar.MONTH;

        int MAX_QRY_TIME_INTERVAL = -3;
    }

    public interface Cache {
        String LATEST_MSG_CHANGED_DATE_PREFIX = "athena:cic:latestMsgChangedDate:%d";
    }

    /**
     * 集合枚举
     */
    public enum CollectionFlagEnum {
        TEMPLATE("template"), // 模板
        APP_EXPIRATION_MESSAGE("appExpirationMessage");  // 应用到期提醒

        private String flag;

        CollectionFlagEnum(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return flag;
        }
    }
}
