package com.digiwin.athena.aim.domain.message.model;

import com.digiwin.athena.appcore.exception.BusinessException;
import lombok.Getter;

public enum ErrorCodeEnum {
    // OK
    OK(200, "OK"),
    FAIL(-1, "the number of personnel cannot over 1000"),

    // 获取Token信息失败
    TENANT_ID_NOT_FOUND(221040400, "从token中未能解析出租户id");

    /**
     * 错误码
     */
    @Getter
    private Integer errCode;

    /**
     * 错误描述
     */
    @Getter
    private String errMsg;

    ErrorCodeEnum(Integer errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @return BusinessException实例
     */
    public BusinessException getBusinessException() {
        return BusinessException.create(this.getErrCode(), this.getErrMsg());
    }
}
