package com.digiwin.athena.aim.domain.message.model;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class EventDTO {

    private String gid;

    private String userId;

    private String userName;

    private String langName;

    private String tenantId;

    /**
     * 消息类型，如：项目：TASK；任务：ACTIVITY
     */
    private String type;
    /**
     * 消息状态，消息状态，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;
    /**
     * 事件内容
     */
    private Object event;
    /**
     * 消息发送时间
     */
    private LocalDateTime sendDate;
    /**
     * 来源
     */
    private String source;

    /**
     * 是否需要设置过期时间
     */
    private Boolean needExpire;

    /**
     * 如果需要过期时间，过期时间设置值
     */
    private String expireTime;
}
