package com.digiwin.athena.aim.domain.message.model;

import lombok.Data;
import net.sf.json.JSONObject;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

/**
 * ExpireMessageReq Description
 *
 * @author sungq
 * @date 2023/10/12
 * @since
 */
@Data
public class ExpireMessageReq {

    /**
     * 租户ID
     */
    @NotBlank(message = "tenantId cannot be null")
    private String tenantId;

    /**
     * 用户ID列表
     */
    @NotEmpty(message = "userIdList cannot be empty")
    private List<String> userIdList;

    /**
     * 消息
     */
    @NotNull(message = "message cannot be null")
    @Valid
    private MessageDTO message;

    @Data
    public static class MessageDTO {

        /**
         * 主键id
         */
        private String gid;

        /**
         * 用户id
         */
        private String userId;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 消息类型 buffer_period：缓冲期 data_retention_period：资料保留期
         */
        @NotBlank(message = "type cannot be null")
        private String type;

        /**
         * 应用code
         */
        @NotBlank(message = "appCode cannot be null")
        private String appCode;

        /**
         * 消息体
         */
        private JSONObject content;

        /**
         * 消息模板
         */
        @Valid
        @NotNull(message = "template cannot be null")
        private TemplateVariableDTO template;

        /**
         * 语言 zh_CN:简体 zh_TW：繁体
         */
        private String locale;

        /**
         * 消息过期时间
         */
        @NotNull(message = "endTime cannot be null")
        private LocalDateTime endTime;

        /**
         * 创建时间
         */
        private LocalDateTime createDate;

        /**
         * 修改时间
         */
        private LocalDateTime modifyDate;
    }
}