package com.digiwin.athena.aim.domain.message.model;

import com.digiwin.athena.aim.common.TargetEnum;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.LanguageUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Data
@NoArgsConstructor
public class MessageDO {
    public static final String DATA_ID = "dataId";

    private String gid;

    @NotBlank(groups = {MessageValidateGroup.NewSingleMessage.class})
    private String userId;

    private String langName;

    @NotBlank(groups = {MessageValidateGroup.NewSingleMessage.class})
    private String tenantId;

    /**
     * 消息类型，如：项目：TASK；任务：ACTIVITY
     */
    @NotBlank
    private String type;

    /**
     * 渠道类型  web  app
     */
    private String channelType;

    /**
     * 消息子类型，如：交期回复异常排除：checkConfirmDeliveryDateSolveProblem
     */
    @NotBlank
    private String subType;

    /**
     * 消息子类型所属类别，如：项目异常/逾期提醒
     */
    @NotBlank
    private String subTypeCategory;

    /**
     * 消息类别，多个消息类别以英文逗号隔开，如：NEW,EMERGENCY
     */
    @NotBlank
    private String category;

    /**
     * 重要性，0：不重要，1：重要
     */
    private Integer importance;

    private String source;

    /**
     * 消息状态，消息状态，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;

    /**
     * 是否已经查看详情
     */
    private Boolean hasReadDetail;

    private String title;

    private JSONObject content;

    private String jsonContent;

    /**
     * 消息发送时间
     */
    private LocalDateTime sendDate;

    /**
     * 消息生效时间
     */
    private LocalDateTime startTime;

    /**
     * 消息过期时间
     */
    private LocalDateTime endTime;

    private LocalDateTime createDate;

    private LocalDateTime modifyDate;

    /**
     * 是否需要通知到移动端APP
     */
    private Boolean noticeMobileApp;

    /**
     * 是否需要通知到在线客户
     */
    private Boolean noticeOnlineUser;

    /**
     * 应用授权信息
     */
    private String appCode;

    private String appName;

    private Boolean hasAppPermission;

    /**
     * 消息模板
     */
    private TemplateVariableDTO template;

    /**
     * 语言 zh_CN:简体 zh_TW：繁体
     */
    private String locale;

    /**
     * 消息跳转行为，定义"点击详情"的跳转逻辑
     */
    private TargetAction action;
    /**
     * 是否过滤非终止消息 ture: 过滤, false: 不过滤
     */
    private Boolean unterminate = false;

    /**
     * 查询的开始时间
     */
    private String startTimeStr;

    /**
     * 查询的结束时间
     */
    private String endTimeStr;

    /**
     * 搜索关键词
     */
    private String key;

    /**
     * 跳转链接
     */
    private String detailUrl;

    @Data
    public static class TargetAction {
        /**
         * 跳转目标
         */
        private String target;

        /**
         * 扩展参数，调用方使用
         */
        private String params;

        /**
         * 敏捷数据-扩展参数(透传)
         */
        private JSONObject adaParams;

        private List<Param> urlParams;

        /**
         * 助理类型
         */
        private String skillType;

        private String type;

        @Data
        public static class Param {
            private String key;
            private String value;
        }
    }

    @JsonIgnore
    public JSONObject convertMobileAppMsg() {
        JSONObject parameter = new JSONObject();
        parameter.put("is_system", false);
        parameter.put("detail_url", this.getDetailUrl());
        parameter.put("service_name", "dinghui.notice.send");
        parameter.put("creator_name", "Athena");
        parameter.put("category_key", "MessageCenter");
        parameter.put("locale", "zh_CN");

        // 消息类型，在哪边传的呢？--通知显示暂时不需要
        parameter.put("title", this.getTitle());
        if (null != this.getContent() && this.getContent().containsKey("msg")) {
            parameter.put("content", this.getContent().getString("msg"));
        }

        parameter.put("outer_tenant_id", this.getTenantId());
        parameter.put("outer_user_id", this.getUserId());

        Map<String, Object> detail = new HashMap<>();
        // 任务
        if (StringUtils.equals(MsgTypeEnum.ACTIVITY.getValue(), this.getType())) {
            detail.put("type", "TASK");

            if (null != this.getContent() && this.getContent().containsKey("id")) {
                Object taskId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put(DATA_ID, taskId);
            } else {
                detail.put(DATA_ID, "");
            }

            detail.put("tmActivityId", this.getSubType());
        }
        // 项目
        else if (StringUtils.equals(MsgTypeEnum.TASK.getValue(), this.getType())) {
            detail.put("type", "PROJECT");

            if (null != this.getContent() && this.getContent().containsKey("id")) {
                Object projectId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put(DATA_ID, projectId);
            } else {
                detail.put(DATA_ID, "");
            }

            detail.put("tmTaskId", this.getSubType());
        } else if (StringUtils.equals(MsgTypeEnum.AGILE_DATA.getValue(), this.getType())) {
            detail.put("type", "AGILE_DATA_DETAIL");

            if (null != this.getContent() && this.getContent().containsKey("id")) {
                Object projectId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put(DATA_ID, projectId);
            } else {
                detail.put(DATA_ID, "");
            }
        }
        // 智驱工作台公告发送
        else if (StringUtils.equals(MsgTypeEnum.NEWS.getValue(), this.getType())) {
            detail.put("type", "NOTICE_DETAIL_PAGE");

            if (null != this.getContent() && this.getContent().containsKey("id")) {
                Object newsId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put("newsId", newsId);
            } else {
                detail.put("newsId", "");
            }
        }
        // 文本类型
        else if (StringUtils.equals(MsgTypeEnum.TEXT.getValue(), this.getType())) {
            TargetAction action = this.getAction();
            // 和移动端约定，娜娜帮我的详情类型传"AI_ASSIStANT"，表示智能助理
            if (action != null && StringUtils.isNotBlank(action.getTarget()) && TargetEnum.NANA.getFlag().equals(action.getTarget())) {
                detail.put("type", "AI_ASSISTANT");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("skillType",action.getSkillType());   // "1":文档助手 "2":敏捷数据 "3":行政助理 "4"顾问助理
                detail.put("aiAssistantParams", jsonObject);
            }
            if (action != null && StringUtils.isNotBlank(action.getTarget()) && TargetEnum.AGILE_DATA.getFlag().equals(action.getTarget())) {
                detail.put("type", action.getType());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("skillType",action.getSkillType());
                jsonObject.put("adaParams", action.getAdaParams());
                detail.put("aiAssistantParams", jsonObject);
            }
        }
        parameter.put("detail", detail);

        JSONObject stdDataJson = new JSONObject();
        stdDataJson.put("parameter", parameter);

        JSONObject noticeAppMsg = new JSONObject();
        noticeAppMsg.put("std_data", stdDataJson);
        return noticeAppMsg;
    }

    @JsonIgnore
    public String getMessageByLanguage(String local) {
        if (local == null) {
            local = "zh_CN";
        }
        if (this.content == null && this.jsonContent != null) {
            //使用map转一下的原因是：
            //  JSONObject会将json格式的字符串，也转换为对象，
            //  name 的值是字符串，直接用JSONObject 转换为转换为一个 对象
            Map map = JsonUtils.jsonToObject(this.jsonContent, Map.class);
            this.content = JSONObject.fromObject(map);
        }
        if (this.content == null) {
            return null;
        }
        String json = JsonUtils.objectToString(this.content);
        Map map = JsonUtils.jsonToObject(json, Map.class);
        JSONObject cloneContentObject = JSONObject.fromObject(map);
        LanguageUtils.processLanguage(cloneContentObject, local);
        JSONObject cloneObject = JSONObject.fromObject(this);
        cloneObject.put("content", cloneContentObject);
        cloneObject.remove("jsonContent");
        return cloneObject.toString();
    }
}
