package com.digiwin.athena.aim.domain.message.model;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author：SYQ
 * @date：2022/4/11
 */
@Data
public class MessageRemindDTO {

    private AuthoredUser authoredUser;
    private Map tsak;
    private Map activity;
    private Map targetUser;
    private Map backlog;

    private String source;
    private String title;
    private String type;
    private  Boolean push;
    private String subType;
    private Object content;
    private String categoryKey;
    private String creatorName;
    private String detailUrl;
    private String msg;
    private List<Map> receivers;

    /**
     * convert MessageDO to MessageRemindDTO
     * @param messageDO MessageDO
     * @return  MessageRemindDTO
     */
    public static MessageRemindDTO convert(MessageDO messageDO) {
        if (messageDO == null) {
            return null;
        }
        MessageRemindDTO messageRemindDTO = new MessageRemindDTO();
//        messageRemindDTO.setAuthoredUser(messageDO.getAuthoredUser());
//        messageRemindDTO.setTsak(messageDO.getTsak());
//        messageRemindDTO.setActivity(messageDO.getActivity());
//        messageRemindDTO.setTargetUser(messageDO.getTargetUser());
//        messageRemindDTO.setBacklog(messageDO.getBacklog());
        messageRemindDTO.setSource(messageDO.getSource());
        messageRemindDTO.setTitle(messageDO.getTitle());
        messageRemindDTO.setType(messageDO.getType());
//        /messageRemindDTO.setPush(messageDO.getPush());
        messageRemindDTO.setSubType(messageDO.getSubType());
        messageRemindDTO.setContent(messageDO.getContent());
//        messageRemindDTO.setCategoryKey(messageDO.getCategoryKey());
//        messageRemindDTO.setCreatorName(messageDO.getCreatorName());
        messageRemindDTO.setDetailUrl(messageDO.getDetailUrl());
//        messageRemindDTO.setMsg(messageDO.getMsg());
//        messageRemindDTO.setReceivers(messageDO.getReceivers());
        return messageRemindDTO;
    }
}
