package com.digiwin.athena.aim.domain.message.model;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * MessageTemplateDTO Description
 *
 * @author sungqz
 * @date 2023/9/18
 * @since
 */
@Data
public class MessageTemplateDTO {

    private String gid;

    /**
     * 模板code
     */
    @NotBlank
    private String code;

    /**
     * 模板名称
     */
    @NotBlank
    private String name;

    /**
     * 模板文本内容
     */
    @NotBlank
    private String content;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 创建时间
     */
    private LocalDateTime createDate;

    /**
     * 修改时间
     */
    private LocalDateTime modifyDate;
}