package com.digiwin.athena.aim.domain.message.model;

import lombok.Data;
import lombok.Getter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * MsgAndEmailBatchDTO Description
 *
 * @author lisheng
 * @date 2024/12/04
 * @since
 */
@Data
public class MsgAndEmailBatchDTO {

    /**
     * 接收人
     */
    @NotEmpty
    private List<String> recivers;

    /**
     * 消息
     */
    @NotNull
    private Content content;

    @Data
    public class Content {
        /**
         * 消息标题
         */
        private Map<String, String> title;
        /**
         * 消息内容
         */
        private Map<String, String> msg;
    }

    /**
     * 跳转路径（如果ssoLogin为false，就要传带有域名的全路径；如果ssoLogin为true，则传相对路径）
     */
    private String linkUrl;

    /**
     *
     */
    private Config config;

    @Data
    public class Config {

        /**
         * 是否需要免登
         */
        private Boolean ssoLogin;

        /**
         * “B/S手工配置”中的应用id
         */
        private String ssoAppCode;

        /**
         *     BS_APPLICATION(1), // BS表
         *     CS_APPLICATION(2), // CS表
         *     PRESET_APPLICATION(3), // 预设表
         *     IAM_APPLICATION(4), // IAM接口
         *     VIRTUAL_APPLICATION(5); // 虚拟应用
         */
        private String appType;
    }

    /**
     * 消息来源（通常为调用方的appCode）
     */
    private String source;

    /**
     * 是否需要通知到移动端APP
     */
    private Boolean noticeMobileApp;

    /**
     * 邮件模板ID 支持邮件模板自定义，不传则用默认模板ATHENA_NOTICE_LINK
     */
    private String emailTemplateId;
}