package com.digiwin.athena.aim.domain.message.model;

import com.digiwin.athena.appcore.exception.BusinessException;

public enum MsgCategoryEnum {
    // 新增
    NEW,
    // 紧急
    EMERGENCY,
    // 异常
    EXCEPTION,
    //逾期
    OVERDUE,
    // 通知
    NOTICE,
    // 代理
    PROXY,
    // 其他
    OTHER;

    public static boolean isValid(String value) {
        for (MsgCategoryEnum categoryEnum : MsgCategoryEnum.values()) {
            if (categoryEnum.name().equals(value)) {
                return true;
            }
        }

        return false;
    }

    public static void invalidWithException(String value) {
        if (!isValid(value)) {
            throw BusinessException.create("invalid category value.");
        }
    }
}
