package com.digiwin.athena.aim.domain.message.model;

import com.digiwin.athena.appcore.exception.BusinessException;
import lombok.Getter;

public enum MsgStateEnum {
    UNREAD(0), READ(1), DELETE(2);

    @Getter
    private int state;

    MsgStateEnum(int state) {
        this.state = state;
    }

    public static boolean isValid(Integer value) {
        if (null == value) {
            return false;
        }

        for (MsgStateEnum stateEnum : MsgStateEnum.values()) {
            if (stateEnum.getState() == value.intValue()) {
                return true;
            }
        }

        return false;
    }

    public static void invalidWithException(Integer value) {
        if (!isValid(value)) {
            throw BusinessException.create("invalid state value.");
        }
    }
}
