package com.digiwin.athena.aim.domain.message.model;

import com.digiwin.athena.appcore.exception.BusinessException;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

public enum MsgSubTypeCategoryEnum {
    // athena提醒
    ATHENA_REMIND(1),
    // 异常
    EXCEPTION_OR_OVERDUE(2),
    // 内部提醒
    INTERNAL_REMIND(3),
    // 代理人提醒
    PROXY_REMIND(4),
    // 其他
    OTHER(99);

    /**
     * 顺序，用于查询排序，值越小显示顺序月靠前
     */
    @Getter
    private int order;

    MsgSubTypeCategoryEnum(int order) {
        this.order = order;
    }

    /**
     * 获取重要消息的子类型分类列表
     *
     * @return
     */
    public static List<String> getImportantSubTypeCategories() {
        return Arrays.asList(ATHENA_REMIND.name(), EXCEPTION_OR_OVERDUE.name(), INTERNAL_REMIND.name(), PROXY_REMIND.name());
    }

    public static MsgSubTypeCategoryEnum customValueOf(String subTypeCategory) {
        for (MsgSubTypeCategoryEnum subTypeCategoryEnum : MsgSubTypeCategoryEnum.values()) {
            if (subTypeCategoryEnum.name().equals(subTypeCategory)) {
                return subTypeCategoryEnum;
            }
        }

        return MsgSubTypeCategoryEnum.OTHER;
    }

    public static boolean isValid(String value) {
        for (MsgSubTypeCategoryEnum subTypeCategoryEnum : MsgSubTypeCategoryEnum.values()) {
            if (subTypeCategoryEnum.name().equals(value)) {
                return true;
            }
        }

        return false;
    }

    public static void invalidWithException(String value) {
        if (!isValid(value)) {
            throw BusinessException.create("invalid subTypeCategory value.");
        }
    }
}
