package com.digiwin.athena.aim.domain.message.model;

import lombok.Data;
import net.sf.json.JSONObject;

import java.util.List;

/**
 * 各个渠道消息发送请求对象
 *
 * @author sungqz
 * @since 2023-11-30
 */
@Data
public class SendCommonChannelMsgReq {
    /**
     * 站内信消息
     */
    private List<MessageBatchUserDTO> remind;

    /**
     * 邮件信息
     */
    private List<MsgInfoReq> email;

    /**
     * 邮件信息
     */
    private List<MsgInfoReq> wecom;

    /**
     * 短信消息
     */
    private List<MsgInfoReq> sms;

    /**
     * 钉钉消息
     */
    private List<MsgInfoReq> dingTalk;

    @Data
    public static class MsgInfoReq {

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 收件人用户id
         */
        private List<String> userIdList;

        /**
         * 抄送人用户id，邮件消息特有字段
         */
        private List<String> ccUserIdList;

        /**
         * 密送人用户id，邮件消息特有字段
         */
        private List<String> bccUserIdList;

        /**
         * 附件id集合，邮件消息特有字段
         */
        private List<String> fileIdList;

        /**
         * 事件对象 短信/钉钉必填，邮件/企微非必填，和text二填一
         */
        private EventReq event;

        /**
         * 文本内容，短信/钉钉忽略该字段，邮件/企微渠道没传事件id时支持传文本内容
         */
        private String text;

        /**
         * 钉钉应用id，必填，钉钉消息特有字段
         */
        private String appId;

        /**
         * 钉钉corpId，必填，钉钉消息特有字段
         */
        private String corpId;

        // 接口文档 http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#6597c9f9a5a497000b26baad
    }

    /**
     * 事件对象
     */
    @Data
    public static class EventReq {

        /**
         * 事件id，短信/钉钉必填，邮件/企微非必填，和text二填一
         */
        private String eventId;

        /**
         * 事件备注
         */
        private String remark;

        /**
         * 变量内容，对应om模板中的变量，格式：{"name":"jack","age":"29"}，短信忽略该字段
         */
        private JSONObject variableData;
    }
}
