package com.digiwin.athena.aim.domain.message.model;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * TemplateVariableDTO Description
 *
 * @author sungqz
 * @date 2023/9/18
 * @since
 */
@Data
public class TemplateVariableDTO {

    /**
     * 模板code
     */
    @NotBlank(message = "code cannot be null")
    private String code;

    /**
     * 变量名和变量值
     */
    @Valid
    @NotEmpty(message = "variableList cannot be empty")
    private List<VariableDTO> variableList;

    @Data
    public static class VariableDTO {

        /**
         * 变量名
         */
        @NotBlank(message = "key cannot be null")
        private String key;

        /**
         * 变量值
         */
        @NotBlank(message = "value cannot be null")
        private String value;
    }
}