package com.digiwin.athena.aim.domain.message.repository;

import com.digiwin.athena.aim.domain.message.model.AppExpireMessageDO;
import com.digiwin.athena.aim.domain.message.model.ExpireMessageReq;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.api.dto.Page;
import com.digiwin.athena.aim.domain.message.model.MessageRemoveDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * MessageMapperV2 Description
 *
 * @author majianfu
 * @date 2021/4/26
 * @since
 */
public interface MessageMapperV2 {
    PageImpl<MessageDO> pagingQuery(MessageDO condition, Page page);

    MessageRemoveDTO updateDeleted(String channelType, AuthoredUser authoredUser);

    long readMessageByGid(String channelType, List<String> gidList, AuthoredUser authoredUser);

    long readMessageDetailByGid(String gid, AuthoredUser authoredUser);

    void batchInsert(List<MessageDO> messageList);

    void clearProjectAndTaskMessage(String tenantId, List<String> projectCodeList, List<String> taskCodeList);

    /**
     * 应用到期提醒 批量发送消息
     *
     * @param messageList 消息
     */
    void insertAppExpirationMessage(List<ExpireMessageReq.MessageDTO> messageList);

    /**
     * 应用到期提醒 查询消息列表
     *
     * @param condition
     * @return
     */
    List<MessageDO> queryAppExpirationMessage(MessageDO condition);

    /**
     * 应用到期提醒 应用续约，即删除该应用的到期提醒
     *
     * @param appExpireMessageDO 请求体
     * @return
     */
    void deleteAppExpirationMessage(AppExpireMessageDO appExpireMessageDO);
}
