package com.digiwin.athena.aim.domain.message.service;

import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageRemindDTO;
import com.digiwin.athena.aim.domain.message.model.TenantRouteChangeMessageDO;

import java.util.List;

/**
 * 通过mqtt来推送消息，后续和前端的通讯都通过mqtt来进行
 */
public interface MessageSendService {

    /**
     * 给指定的租户+用户发送消息
     *
     * @param tenantId 租户id
     * @param userId   用户id
     * @param payload  数据
     */
    void sendToClient(String tenantId, String userId, MessageDO payload);

    /**
     * 给指定的租户+前端应用发送路由变化消息
     *
     * @param tenantId 租户id
     * @param app   用户id
     * @param payload  数据
     */
    void sendTenantRouteChange(String tenantId, String app, TenantRouteChangeMessageDO payload);

    /**
     * @Author：SYQ
     * @Date：2022/4/11 14:47
     */
    void sendMessageRemindToClient(MessageRemindDTO messageRemindDTO);

    /**
     * @Author：SYQ
     * @Date：2022/4/11 14:47
     */
    void sendMessageRemindToClient(List<MessageRemindDTO> messageList);

    /**
     * App 消息推波
     * @param tenantId
     * @param userId
     * @param message
     */
    void sendToAppClient(String tenantId, String userId, MessageDO message);
}
