package com.digiwin.athena.aim.domain.message.service;

import com.digiwin.athena.aim.api.dto.MessagePagingQryCommand;
import com.digiwin.athena.aim.domain.message.model.*;
import net.sf.json.JSONObject;
import org.springframework.http.ResponseEntity;

import java.util.List;

/**
 * MessageServiceV2 Description
 *
 * @author majianfu
 * @date 2021/4/25
 * @since
 */
public interface MessageServiceV2 {
    ResponseEntity<?> pagingQueryMessage(MessagePagingQryCommand msgPagingReq);

    ResponseEntity<?> summaryRemove(String channelType);

    ResponseEntity<?> readMessageByGid(List<String> gidList);

    /**
     * 一键已读当用户的工作提醒
     *
     * @return 返回
     */
    ResponseEntity<?> readMessageAll(String channelType);

    ResponseEntity<?> readMessageDetailByGid(String gid);

    void newMessageForBatchUsers(List<MessageBatchUserDTO> messageBatchUserList);

    /**
     * 应用到期提醒 批量发送消息
     *
     * @param expireMessageReq
     */
    void insertAppExpirationMessage(ExpireMessageReq expireMessageReq);

    /**
     * 应用到期提醒 查询消息列表
     *
     * @param platformFlag 调用来源标识
     * @return
     */
    List<MessageDO> queryAppExpirationMessage(Integer platformFlag);

    /**
     * 应用到期提醒 应用续约，即删除该应用的到期提醒
     *
     * @param appExpireMessageDO 请求体
     * @return
     */
    void deleteAppExpirationMessage(AppExpireMessageDO appExpireMessageDO);

    /**
     * 各渠道发送消息
     *
     * @param channelFlag email：邮箱 sms：短信 wecom：企微 dingTalk：钉钉
     * @param msgInfoReqList 请求消息体
     */
    JSONObject sendCommonChannelMessage(String channelFlag, List<SendCommonChannelMsgReq.MsgInfoReq> msgInfoReqList);


    /**
     * 发送消息/邮件
     * @param msgAndEmailBatchDTOList
     */
    void sendMsgAndEmail(List<MsgAndEmailBatchDTO> msgAndEmailBatchDTOList);
}
