package com.digiwin.athena.aim.domain.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.CacheKeys;
import com.digiwin.athena.aim.common.Constants;
import com.digiwin.athena.aim.domain.message.model.*;
import com.digiwin.athena.aim.domain.message.service.DingDingMessageService;
import com.digiwin.athena.aim.infrastructure.atmc.AtmcService;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.thememap.dto.IamDdMessageDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.IamDdMessageDataDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationReqDTO;
import com.digiwin.athena.aim.infrastructure.thememap.service.ThemeMapService;
import com.digiwin.athena.aim.util.AESUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

import static com.digiwin.athena.aim.common.CategoryEnum.EXCEPTION;
import static com.digiwin.athena.aim.common.CategoryEnum.SHARE_NOTICE;
import static com.digiwin.athena.aim.common.CategoryEnum.SIGN_NOTICE;
import static com.digiwin.athena.aim.common.Constants.MESSAGE_TYPE_ACTIVITY;
import static com.digiwin.athena.aim.common.Constants.MESSAGE_TYPE_SHARE_PROJECT;
import static com.digiwin.athena.aim.common.Constants.MESSAGE_TYPE_TASK;
import static com.digiwin.athena.aim.common.Constants.MESSAGE_TYPE_TASK_REMINDER;
import static com.digiwin.athena.aim.common.Constants.TASK_DETAIL_SHARE;
import static com.digiwin.athena.aim.common.MeesqgeConstant.SUMMARY_YES;

/**
 * 钉钉发送消息
 */
@Slf4j
@Service
public class DingDingMessageServiceImpl implements DingDingMessageService {


    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private EnvProperties envProperties;

    @Resource
    private EmcService emcService;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private AtmcService atmcService;

    @Autowired
    private IamService iamService;

    @Autowired
    private MessageUtils messageUtils;


    private void sendAsaDingDingMessage(MessageBatchUserDTO messageBatchUserDTO) throws UnsupportedEncodingException {
        //判断是否需要发送钉钉消息
        String dingding = iamService.getUserMetadataAllTenant(messageBatchUserDTO.getUserIdList().get(0), 2,2);
        if (StringUtils.isBlank(dingding)){
            return;
        }
        MessageDO message = messageBatchUserDTO.getMessage();
        JSONObject param = new JSONObject();
        param.put("tenantId",messageBatchUserDTO.getTenantId());
        param.put("appType","dingTalk");
        param.put("sysId","Athena");
        param.put("appCategory","outsource");
        Map appConfig = emcService.getAppConfig(param);
        //跳转链接需要前端提供
        String redirect_uri = String.format(Constants.NANA_DINGDINGD_MESSAGE_PC_URL, envProperties.getAniaAddressUri());
        String urlPath;
//        JSONObject nanaParams = new JSONObject();
//        nanaParams.put("assistantCode", message.getAction().getAssistantCode());
   //消息详情地址,app点击跳转地址
//        String appUri = getNaNaAppShareUrl();
        //消息详情地址,获取pc分享地址
        String messageUri = getNaNaPcShareUrl(messageBatchUserDTO, "Athena",MapUtils.getString(appConfig,"corpId"));
        /*if ("AGILE_DATA".equalsIgnoreCase(message.getSource()) && StringUtils.isNotBlank(message.getAction().getType()) && message.getAction().getType().equals("AGILE_DATA_SUBSCRIPTION")) {
            //敏捷数据拼接url信息
            urlPath = redirect_uri + "?" + String.format(Constants.METRIC_REDIRECT_URL,  "nanaSubscriptionDetail", messageBatchUserDTO.getTenantId(), messageBatchUserDTO.getUserIdList().get(0), AESUtils.encode2(JSON.toJSONString(nanaParams)), message.getAction().getAdaParams().containsKey("question") ? URLEncoder.encode(message.getAction().getAdaParams().getString("question"), "utf-8") : null, message.getAction().getAdaParams().containsKey("snapshotId") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("snapshotId")) : null, message.getAction().getAdaParams().containsKey("sendDate") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("sendDate")).replace("+","%20") : null, message.getAction().getAdaParams().containsKey("undeletable") ? message.getAction().getAdaParams().getBoolean("undeletable") : null, message.getAction().getAdaParams().containsKey("dataTipMessage") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("dataTipMessage")) : null);
        } else {
            String workitemId = message.getAction().getWorkitemId();
            if (StringUtils.isNotBlank(workitemId)){
                nanaParams.put("workitemId", workitemId);
            }
            urlPath = redirect_uri + "?" + String.format(Constants.NANA_REDIRECT_URL_DINGDING, messageBatchUserDTO.getTenantId(), messageBatchUserDTO.getUserIdList().get(0),
                    nanaParams);
        }*/
        urlPath = redirect_uri + "?" + messageUri;
        //urlPath = urlPath + "&appId="+ "Athena";
        String encode = URLEncoder.encode(urlPath, "utf-8");
        String dingDingUrl = encode;
        // 构造发送参数
        JSONObject msgJson = new JSONObject();
        JSONObject dataJsonObject = new JSONObject();
        dataJsonObject.put("appId", "Athena");
        dataJsonObject.put("userList", messageBatchUserDTO.getUserIdList());
        dataJsonObject.put("tenantId",messageBatchUserDTO.getTenantId());
        if (appConfig != null && appConfig.size() > 0){
            StringBuilder sb = new StringBuilder("dingtalk://dingtalkclient/action/openapp?corpid=").append(MapUtils.getString(appConfig,"corpId")).append("&container_type=work_platform&app_id=0_").append(MapUtils.getString(appConfig,"agentId")).append("&redirect_type=jump&redirect_url=").append(dingDingUrl);
            dingDingUrl = sb.toString();
        }
        dataJsonObject.put("messageData", buildMessageData(messageBatchUserDTO, dingDingUrl));
        msgJson.put("message", new com.alibaba.fastjson.JSONObject().fluentPut("data", dataJsonObject));
        msgJson.put("types", Lists.newArrayList("dingTalkInner"));
        msgJson.put("eventId", envProperties.getAsaNoticeEventId());
        emcService.sendCommonChannelMsg(messageBatchUserDTO.getMessage().getLocale(), msgJson);
        log.info("message send success");
    }

    @Override
    public void senDingDingMessage(MessageBatchUserDTO messageBatchUser) throws UnsupportedEncodingException{

        MessageDO message = messageBatchUser.getMessage();
        if (message == null) {
            return;
        }
        //定义消息类型Map
        Map<String, String> typeMap = ImmutableMap.of(MESSAGE_TYPE_ACTIVITY, MESSAGE_TYPE_TASK, MESSAGE_TYPE_SHARE_PROJECT, MESSAGE_TYPE_TASK_REMINDER);
        if (("ASA".equalsIgnoreCase(message.getSource()) && Constants.MESSAGE_TYPE_TEXT.equalsIgnoreCase(message.getType())) || "AGILE_DATA".equalsIgnoreCase(message.getSource())) {
            // 发送娜娜消息任务(type=text,source=ASA) 或 敏捷数据消息（source=AGILE_DATA）
            sendAsaDingDingMessage(messageBatchUser);
            return;
        } else if (!typeMap.containsKey(message.getType().toLowerCase())) {
            //只发送activity和task类型消息 任务中的任务催办比较特殊 type是reminder
            log.info("senDingDingMessage 发送消息type不在范围内,type:{}", message.getType());
            return;
        }

        //获取应用的appCode
        KmApplicationRelationDTO applicationRelationDTO = getAppCode(message.getSubType(), typeMap.get(message.getType().toLowerCase()));
        if (null == applicationRelationDTO) {
            log.info("senDingDingMessage 请求KM获取应用信息appCode为空 MessageDO:{}", JsonUtils.objectToString(message));
            return;
        }
        MessageContentDO messageContentDO = JsonUtils.jsonToObject(message.getContent().toString(), MessageContentDO.class);
        if (null == messageContentDO) {
            log.info("senDingDingMessage 消息内容为空,message:{}", JsonUtils.objectToString(message));
            return;
        }
        String msg = getSendMsg(messageContentDO);
        //构造任务中任务催办消息
        if (MESSAGE_TYPE_TASK_REMINDER.equals(message.getType())) {
            String reminderMsg = assembleTaskReminder(messageBatchUser);
            if (StringUtils.isNotBlank(reminderMsg)) {
                msg = reminderMsg;
            }
        }
        //如果是任务项目分享、签核知会  项目异常 进行msg和title的拼接
        if (StringUtils.isNotBlank(messageContentDO.getTitle()) && StringUtils.isNotBlank(message.getCategory()) &&
                (SHARE_NOTICE.name().equals(message.getCategory()) || SIGN_NOTICE.name().equals(message.getCategory()) ||
                        (MESSAGE_TYPE_TASK.equals(message.getType()) && EXCEPTION.name().equals(message.getCategory())))) {
            msg = messageContentDO.getTitle() + msg;
        }
        if (StringUtils.isEmpty(msg)) {
            log.info("senDingDingMessage 发送钉钉消息内容为空");
            return;
        }
        //获取租户的钉钉corpid
        String corpid=iamService.getTenantCorpid();
        if(StringUtils.isEmpty(corpid)){
            corpid=messageBatchUser.getTenantId();
        }
        //组装发送钉钉消息体
        IamDdMessageDTO iamDdMessageDTO = new IamDdMessageDTO();
        iamDdMessageDTO.setAppId(applicationRelationDTO.getAppCode());
        //语言
        iamDdMessageDTO.setLocale(message.getLocale());
        iamDdMessageDTO.setCorpId(corpid);
        iamDdMessageDTO.setTenantId(messageBatchUser.getTenantId());
        //消息接收人ID
        iamDdMessageDTO.setUserList(messageBatchUser.getUserIdList());
        //拼装消息体内容
        IamDdMessageDataDTO messageDataDTO = new IamDdMessageDataDTO();
        //推送钉钉的消息内容
        messageDataDTO.setDataUrl(msg);
        //消息详情地址,app点击跳转地址
        String appUri = getAppShareUrl(messageContentDO.getId(), applicationRelationDTO.getAppName(), applicationRelationDTO.getAppCode(), messageBatchUser.getTenantId(),corpid);
        messageDataDTO.setAppUri(appUri);
        //消息详情地址,获取pc分享地址
        String messageUri = getPcShareUrl(messageContentDO.getId(), MESSAGE_TYPE_TASK_REMINDER.equalsIgnoreCase(message.getType()) ? MESSAGE_TYPE_ACTIVITY : message.getType(), applicationRelationDTO.getAppCode(), corpid);
        //拼接非分享方式的地址，这种方式只是适用于任务卡，项目卡必须带有shareCode
        //String messageUri=Constants.TASK_DETAIL_NO_SHARECODE+messageContentDO.getId();
        messageDataDTO.setMessageUri(messageUri);
        //租户钉钉的corpId
        messageDataDTO.setTenantId(corpid);
        iamDdMessageDTO.setMessageData(messageDataDTO);
        emcService.senDdMessage(iamDdMessageDTO);
    }


    /**
     * 获取app分享地址
     *
     * @param taskId
     * @param appName
     * @return https://athena-mobile-inner-test.apps.digiwincloud.com.cn/#/?appId=TBDS
     * &appName=试研北斗&corpId=ding7ab87c867d9170e535c2f4657eb6378f
     * &sourceType=ding_talk&dataId=390488111022272
     * &targetTenantId=ding7ab87c867d9170e535c2f4657eb6378f
     */
    public String getAppShareUrl(String taskId, String appName, String appId, String tenantId,String corpid) {
        String messageUrl = String.format(Constants.MESSAGE_DINGTALK_APP_URL, envProperties.getAthenaMobileUri(), appId, appName,corpid,taskId,tenantId);
        //地址进行URLEncoder 编码
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("getAppShareUrl URLEncoder报错， e：{}", e);
        }
        return messageUrl;
    }


    /**
     * 获取pc分享地址
     *
     * @param taskId
     * @param msgType
     * @return https://mui-72005592-test.digiwincloud.com.cn/login/dingtalk-login?
     * appId=middleware&corpId=ding7ab87c867d9170e535c2f4657eb6378f
     * &dingLog=2&routerLink=project-task-detail/566521006903360
     */
    public String getPcShareUrl(String taskId, String msgType, String appId, String corpId) {
        String shareUrl = "";
        String messageUrl = String.format(Constants.MESSAGE_DINGTALK_URL, envProperties.getAthenaDdUri(), appId, corpId);
        //转小写
        msgType = msgType.toLowerCase();
        //转换类型，项目用project，任务卡用task 获取分享code
        String shareMsgType = msgType.equals(MESSAGE_TYPE_ACTIVITY) ? Constants.MESSAGE_TYPE_TASK : Constants.MESSAGE_TYPE_SHARE_PROJECT;
        //请求atmc获取分享code
        String shareCode = atmcService.getShareCode(taskId, shareMsgType);
        //项目卡分享
        if (msgType.equals(Constants.MESSAGE_TYPE_TASK)) {
            shareUrl = String.format(Constants.PROJECT_TASK_DETAIL, taskId, shareCode);
        }
        //任务卡分享
        if (msgType.equals(MESSAGE_TYPE_ACTIVITY)) {
            shareUrl = String.format(Constants.TASK_DETAIL_SHARE, taskId, shareCode);
        }
        messageUrl = messageUrl + shareUrl;
        //地址进行URLEncoder 编码
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("senDingDingMessage URLEncoder报错， e：{}", e);
        }
        return messageUrl;
    }

    /**
     * 获取娜娜app分享地址
     *
     * @param
     * @param
     * @return
     */
    public String getNaNaAppShareUrl() {
        String messageUrl = String.format(Constants.NANA_MESSAGE_DINGTALK_APP_URL, envProperties.getAthenaMobileUri(), 1);
        //地址进行URLEncoder 编码
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("getAppShareUrl URLEncoder报错， e：{}", e);
        }
        return messageUrl;
    }


    /**
     * 获取娜娜pc分享地址
     *
     * @param messageBatchUserDTO
     * @param appCode
     * @param
     * @return
     *
     */
    public String getNaNaPcShareUrl(MessageBatchUserDTO messageBatchUserDTO, String appCode,String corpId) {
        MessageDO message = messageBatchUserDTO.getMessage();

//        JSONObject nanaParams = new JSONObject();
//        nanaParams.put("assistantCode", message.getAction().getAssistantCode());
//
//        if ("AGILE_DATA".equalsIgnoreCase(message.getSource()) && StringUtils.isNotBlank(message.getAction().getType()) && message.getAction().getType().equals("AGILE_DATA_SUBSCRIPTION")) {
//            //敏捷数据拼接url信息
//            urlPath =   String.format(Constants.METRIC_REDIRECT_URL,  "nanaSubscriptionDetail", messageBatchUserDTO.getTenantId(), messageBatchUserDTO.getUserIdList().get(0), AESUtils.encode2(JSON.toJSONString(nanaParams)),
//                    message.getAction().getAdaParams().containsKey("question") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("question")) : null,
//                    message.getAction().getAdaParams().containsKey("snapshotId") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("snapshotId")) : null, message.getAction().getAdaParams().containsKey("sendDate") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("sendDate")).replace("+","%20") : null,
//                    message.getAction().getAdaParams().containsKey("undeletable") ? message.getAction().getAdaParams().getBoolean("undeletable") : null, message.getAction().getAdaParams().containsKey("dataTipMessage") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("dataTipMessage")) : null,
//            message.getAction().getAdaParams().containsKey("method") ? message.getAction().getAdaParams().getString("method") : null, message.getAction().getAdaParams().containsKey("metricIdList") ? AESUtils.encode2(JSON.toJSONString(message.getAction().getAdaParams().getJSONArray("metricIdList"))) : null);
//        } else {
//            String workitemId = message.getAction().getWorkitemId();
//            if (StringUtils.isNotBlank(workitemId)){
//                nanaParams.put("workitemId", workitemId);
//            }
//            urlPath =  String.format(Constants.NANA_REDIRECT_URL, "nana", messageBatchUserDTO.getTenantId(), messageBatchUserDTO.getUserIdList().get(0), AESUtils.encode2(JSON.toJSONString(nanaParams)));
//        }
        String messageUrl = String.format(Constants.NANA_MESSAGE_DINGTALK_URL,appCode,corpId);
        StringBuilder urlPath = new StringBuilder().append(messageUrl).append("&");
        List<MessageDO.TargetAction.Param> urlParams = message.getAction().getUrlParams();
        for (int j = 0; j < urlParams.size(); j++){
            urlPath.append(urlParams.get(j).getKey()).append("=").append(urlParams.get(j).getValue());
            if (j < (urlParams.size() - 1)){
                urlPath.append("&");
            }
        }

        //String param = String.format(Constants.NANA_MESSAGE_DINGTALK_URL, envProperties.getAniaWebAddressUri(), appCode, urlPath,corpId);
        //地址进行URLEncoder 编码
        /*try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("senDingDingMessage URLEncoder报错， e：{}", e);
        }*/
        return urlPath.toString();
    }


    /**
     * 解析获取需要发送钉钉的消息内容
     *
     * @return
     */
    public String getSendMsg(MessageContentDO messageContentDO) {

        //优先取发送邮件内容作为消息内容
        if (StringUtils.isNotEmpty(messageContentDO.getEmailMsg())) {
            return messageContentDO.getEmailMsg();
        }
        //取发送内容
        if (StringUtils.isNotEmpty(messageContentDO.getMsg())) {
            return messageContentDO.getMsg();
        }
        //取发送标题作为消息内容
        if (StringUtils.isNotEmpty(messageContentDO.getTitle())) {
            return messageContentDO.getTitle();
        }
        //取任务名称作为消息内容
        if (StringUtils.isNotEmpty(messageContentDO.getName())) {
            return messageContentDO.getName();
        }
        return "";
    }

    /**
     * 根据任务Code或者项目code获取应用信息
     *
     * @param subType 任务Code或者项目code
     * @param type    项目/发起项目 project    任务/基础资料/报表  task
     * @return
     */
    public KmApplicationRelationDTO getAppCode(String subType, String type) {

        KmApplicationRelationDTO appInfo = null;
        if (StringUtils.isEmpty(subType)) {
            return appInfo;
        }
        String cacheKey = CacheKeys.DD_APP_CODE_MESSAGE + subType;
        //先从缓存中获取
        String appInfoJson = stringRedisTemplate.opsForValue().get(cacheKey);
        //缓存中存在，返回缓存中应用信息
        if (StringUtils.isNotEmpty(appInfoJson)) {
            appInfo=JsonUtils.jsonToObject(appInfoJson,KmApplicationRelationDTO.class);
            return appInfo;
        }
        //缓存中没有应用信息，从KM查询
        KmApplicationRelationReqDTO relationReqDTO = new KmApplicationRelationReqDTO();
        relationReqDTO.setType(type);
        List<String> codeList = new ArrayList<>();
        codeList.add(subType);
        relationReqDTO.setCodes(codeList);
        List<KmApplicationRelationDTO> relationDTOList = themeMapService.getApplicationRelation(relationReqDTO);
        if (CollectionUtils.isNotEmpty(relationDTOList)) {
            appInfo = relationDTOList.get(0);
            //将应用信息存redis，有效期7天
            stringRedisTemplate.opsForValue().set(cacheKey,  JsonUtils.objectToString(relationDTOList.get(0)), Constants.APP_CODE_VALIDITY, TimeUnit.DAYS);
        }
        return appInfo;
    }

    /*private void sendAsaDingDingMessage(MessageBatchUserDTO messageBatchUser){
        //获取租户的钉钉corpid
        String corpid = iamService.getTenantCorpid();
        if (StringUtils.isBlank(corpid)) {
            return;
        }
        //组装发送钉钉消息体
        IamDdMessageDTO iamDdMessageDTO = new IamDdMessageDTO();
        iamDdMessageDTO.setAppId("Athena");
        //语言
        iamDdMessageDTO.setLocale(messageBatchUser.getMessage().getLocale());
        iamDdMessageDTO.setCorpId(corpid);
        iamDdMessageDTO.setTenantId(messageBatchUser.getTenantId());
        //消息接收人ID
        iamDdMessageDTO.setUserList(messageBatchUser.getUserIdList());
        //拼装消息体内容
        IamDdMessageDataDTO messageDataDTO = new IamDdMessageDataDTO();
        //推送钉钉的消息内容
        JSONObject content = messageBatchUser.getMessage().getContent();
        String msg = content.getString("msg");

        messageDataDTO.setDataUrl(msg);
        //消息详情地址,app点击跳转地址
        String appUri = getNaNaAppShareUrl();
        messageDataDTO.setAppUri(appUri);
        //消息详情地址,获取pc分享地址
        String messageUri = getNaNaPcShareUrl(messageBatchUser, "Athena");
        messageDataDTO.setMessageUri(messageUri);
        //租户钉钉的corpId
        messageDataDTO.setTenantId(corpid);

        messageDataDTO.setMessage(msg);

        iamDdMessageDTO.setMessageData(messageDataDTO);



        emcService.sendCommonChannelMsg(messageBatchUser.getMessage().getLocale(), msgJson);

        log.info("message send success");
        emcService.senDdMessage(iamDdMessageDTO);
    }*/

    private JSONObject buildMessageData(MessageBatchUserDTO messageBatchUserDTO, String dingidngChatUrl) {
        MessageDO message = messageBatchUserDTO.getMessage();
        JSONObject content = message.getContent();
        String msg = content.getString("msg");
        String title;
        String description;
        String locale = StringUtils.isNotBlank(message.getLocale()) && message.getLocale().equals(Constants.ZH_CN_LOCALE) ? Constants.ZH_CN_LOCALE : Constants.ZH_TW_LOCALE;
        title = messageUtils.getMessageByLangName("meesage.wecom.title", locale);
        if ("AGILE_DATA".equalsIgnoreCase(message.getSource())) {
            description = "【" + content.getString("title") + "】\n" + msg;
        } else {
            if (StringUtils.isNotBlank(content.getString("msg"))) {
                description = msg;
            } else {
                description = messageUtils.getMessageByLangName("meesage.wecom.description", locale);
            }
        }
        return buildTaskButtonsMsg(title, description, dingidngChatUrl, messageUtils.getMessageByLangName("message.line.button", locale));
    }

    private JSONObject buildTaskButtonsMsg(String title, String description, String url, String btntxt) {
        JSONObject taskMsg = new JSONObject();
        taskMsg.put("title", title);
        taskMsg.put("markdown", description);
        taskMsg.put("single_title", btntxt);
        taskMsg.put("single_url", url);
        return taskMsg;
    }

    /**
     * 组装任务催办提醒消息
     * @param messageBatchUserDTO
     * @return
     */
    private String assembleTaskReminder(MessageBatchUserDTO messageBatchUserDTO){
        List<String> userIdList = messageBatchUserDTO.getUserIdList();
        if (org.springframework.util.CollectionUtils.isEmpty(userIdList)) {
            return "";
        }
        JSONObject content = messageBatchUserDTO.getMessage().getContent();
        if (org.springframework.util.CollectionUtils.isEmpty(content)) {
            return "";
        }
        String userId = userIdList.get(0);
        //查询用户的语言别
        String langName = iamService.getUserMetadataAllTenant(userId, 1,0);
        String projectName = MapUtils.getString(content, "projectName", "");
        String taskName = MapUtils.getString(content, "taskName", "");
        String personInChargeName = MapUtils.getString(content, "personInChargeName", "");
        String performerId = MapUtils.getString(content, "performerId", "");
        String planEndTime = MapUtils.getString(content, "planEndTime", "");
        //根据语言级别获取对应级别语言
        if (StringUtils.isNotBlank(projectName)) {
            projectName = MessageUtils.getMessageByLanguage(projectName, langName);
        }
        if (StringUtils.isNotBlank(taskName)) {
            taskName = MessageUtils.getMessageByLanguage(taskName, langName);
        }
        if (StringUtils.isNotBlank(personInChargeName)) {
            personInChargeName = MessageUtils.getMessageByLanguage(personInChargeName, langName);
        }
        //任务执行者和接收消息是同一个 走任务催办执行人消息模板  否则走任务催办非执行人消息模板
        if (performerId.equals(userId)) {
            return MessageFormat.format(messageUtils.getMessageByLangName("task.reminder.executor.msg", langName), planEndTime, taskName);
        }
        return MessageFormat.format(messageUtils.getMessageByLangName("task.reminder.no.executor.msg", langName), taskName, projectName, personInChargeName);
    }

}
