package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.domain.message.model.EventDTO;
import com.digiwin.athena.aim.domain.message.service.EventMqService;
import com.digiwin.athena.aim.infrastructure.mq.MqConstant;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/**
 * 事件通知
 */
@Slf4j
@Service
public class EventMqServiceImpl implements EventMqService {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    /**
     * 发送催办事件通知
     */
    @Override
    public void sendUrgeDealEventMq(EventDTO eventDTO) {
        log.info("sendUrgeDealEventMq-eventDTO:{}",JsonUtils.objectToString(eventDTO));
        if (null != eventDTO.getNeedExpire() && eventDTO.getNeedExpire()){
            MessageProperties messageProperties = new MessageProperties();
            //设置消息的过期时间 单位 ms
            messageProperties.setExpiration(eventDTO.getExpireTime());
            Message msg = new Message(JsonUtils.objectToString(eventDTO).getBytes(), messageProperties);
            rabbitTemplate.convertAndSend(MqConstant.AIM_EVENT_EXCHANGE, "", msg);
        }
        else {
            rabbitTemplate.convertAndSend(MqConstant.AIM_EVENT_EXCHANGE,"", JsonUtils.objectToString(eventDTO));
        }
        log.info("sendUrgeDealEventMq-eventDTO-success:{}",JsonUtils.objectToString(eventDTO));
    }


//    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = "AIM_TEST_QUEUE_A", durable = "true", autoDelete = "false")
//            , exchange = @Exchange(value = MqConstant.AIM_EVENT_EXCHANGE, type = ExchangeTypes.FANOUT)))
//    public void testA(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag){
//        System.out.println("AIM_TEST_QUEUE_A收到了消息：" + data);
//    }
//
//    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = "AIM_TEST_QUEUE_B", durable = "true", autoDelete = "false")
//            , exchange = @Exchange(value = MqConstant.AIM_EVENT_EXCHANGE, type = ExchangeTypes.FANOUT)))
//    public void testB(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag){
//        System.out.println("AIM_TEST_QUEUE_B收到了消息：" + data);
//    }
//
//    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = "AIM_TEST_QUEUE_C", durable = "true", autoDelete = "false")
//            , exchange = @Exchange(value = MqConstant.AIM_EVENT_EXCHANGE, type = ExchangeTypes.FANOUT)))
//    public void testC(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag){
//        System.out.println("AIM_TEST_QUEUE_C收到了消息：" + data);
//    }

}
