package com.digiwin.athena.aim.domain.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.Constants;
import com.digiwin.athena.aim.common.MessageChannelEnum;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageContentDO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.service.LineMessageService;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.util.AESUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.loadbalance.service.TenantIdService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * line消息发送
 *
 * @author hujun
 * @since 2024年12月31日 14:39:33
 */
@Slf4j
@Service
public class LineMessageServiceImpl implements LineMessageService {

    @Resource
    private EmcService emcService;

    @Autowired
    private IamService iamService;

    @Resource
    private EnvProperties envProperties;

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 异步批量发送line消息
     *
     * @param messageBatchUserDTO 消息列表
     */
    @Override
    public void sendLineMessage(MessageBatchUserDTO messageBatchUserDTO) throws UnsupportedEncodingException {
        MessageDO message = messageBatchUserDTO.getMessage();
        // 判断消息是否为空
        if (message == null) {
            return;
        }

        MessageContentDO messageContentDO = JsonUtils.jsonToObject(JsonUtils.objectToString(message.getContent()), MessageContentDO.class);
        if (null == messageContentDO) {
            log.info("sendLineMessage | content is empty, message:{}", JsonUtils.objectToString(message));
            return;
        }
        String lineKey = iamService.getUserMetadataAllTenant(messageBatchUserDTO.getUserIdList().get(0), 2,1);
        if (StringUtils.isBlank(lineKey)) {
            //如果没有对应的line相关绑定信息直接返回
            return;
        }

        JSONObject content = message.getContent();
        String msg = content.getString("msg");

        String messageText;
        String buttonName;
        String altText;
        String messageByLangName;
        if (StringUtils.isNotBlank(message.getLocale()) && message.getLocale().equals(Constants.ZH_TW_LOCALE)) {
            if ("AGILE_DATA".equalsIgnoreCase(message.getSource())) {
                messageByLangName = "【" + content.getString("title") + "】\n" + msg;
            } else {
                messageByLangName = messageUtils.getMessageByLangName("message.line.urge", Constants.ZH_TW_LOCALE);
            }
            messageText = String.format(messageByLangName, msg);
            buttonName = messageUtils.getMessageByLangName("message.line.button", Constants.ZH_TW_LOCALE);
            altText = messageUtils.getMessageByLangName("message.line.altText", Constants.ZH_TW_LOCALE);
        } else {
            if ("AGILE_DATA".equalsIgnoreCase(message.getSource())) {
                messageByLangName = "【" + content.getString("title") + "】\n" + msg;
            } else {
                messageByLangName = messageUtils.getMessageByLangName("message.line.urge", Constants.ZH_CN_LOCALE);
            }
            messageText = String.format(messageByLangName, msg);
            buttonName = messageUtils.getMessageByLangName("message.line.button", Constants.ZH_CN_LOCALE);
            altText = messageUtils.getMessageByLangName("message.line.altText", Constants.ZH_CN_LOCALE);
        }
        StringBuilder urlPath = new StringBuilder();
        List<MessageDO.TargetAction.Param> urlParams = message.getAction().getUrlParams();
        for (int i = 0; i < urlParams.size(); i++){
            urlPath.append(urlParams.get(i).getKey()).append("=").append(urlParams.get(i).getValue());
            if (i < (urlParams.size() - 1)){
                urlPath.append("&");
            }
        }

//        JSONObject nanaParams = new JSONObject();
//        nanaParams.put("assistantCode", message.getAction().getAssistantCode());
//        nanaParams.put("assistantCode", message.getAction().getAssistantCode());
//        if ("AGILE_DATA".equalsIgnoreCase(message.getSource()) && StringUtils.isNotBlank(message.getAction().getType()) && message.getAction().getType().equals("AGILE_DATA_SUBSCRIPTION")) {
//            //敏捷数据拼接url信息
//            urlPath = envProperties.getAsaLineUrl() + "?" + String.format(Constants.METRIC_REDIRECT_URL,  "nanaSubscriptionDetail", messageBatchUserDTO.getTenantId(), messageBatchUserDTO.getUserIdList().get(0), AESUtils.encode2(JSON.toJSONString(nanaParams)),
//                    message.getAction().getAdaParams().containsKey("question") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("question")) : null,
//                    message.getAction().getAdaParams().containsKey("snapshotId") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("snapshotId")) : null, message.getAction().getAdaParams().containsKey("sendDate") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("sendDate")).replace("+","%20") : null,
//                    message.getAction().getAdaParams().containsKey("undeletable") ? message.getAction().getAdaParams().getBoolean("undeletable") : null, message.getAction().getAdaParams().containsKey("dataTipMessage") ? AESUtils.encodeString(message.getAction().getAdaParams().getString("dataTipMessage")) : null,
//            message.getAction().getAdaParams().containsKey("method") ? message.getAction().getAdaParams().getString("method") : null, message.getAction().getAdaParams().containsKey("metricIdList") ? AESUtils.encode2(JSON.toJSONString(message.getAction().getAdaParams().getJSONArray("metricIdList"))) : null);
//        } else {
//            String workitemId = message.getAction().getWorkitemId();
//            if (StringUtils.isNotBlank(workitemId)){
//                nanaParams.put("workitemId", workitemId);
//            }
//            urlPath = envProperties.getAsaLineUrl() + "?" + String.format(Constants.NANA_REDIRECT_URL, "nana", messageBatchUserDTO.getTenantId(), messageBatchUserDTO.getUserIdList().get(0), AESUtils.encode2(JSON.toJSONString(nanaParams)));
//        }
        String encode = URLEncoder.encode(urlPath.toString(), "utf-8").replace("+","%20");
        JSONObject messageData = buildTaskUrgeButtonsMsg(messageText, envProperties.getAsaLineUrl() + "?" + encode, buttonName, altText);

        // 构造发送参数
        JSONObject msgJson = new JSONObject();
        JSONObject dataJsonObject = new JSONObject();
        dataJsonObject.put("appId", "Athena");
        dataJsonObject.put("userList", messageBatchUserDTO.getUserIdList());
        dataJsonObject.put("thirdUserList", new String[]{});
        dataJsonObject.put("messageData", messageData);

        JSONObject data = new JSONObject();
        data.put("data", dataJsonObject);
        msgJson.put("message", data);
        msgJson.put("types", Lists.newArrayList("line"));
        msgJson.put("eventId", envProperties.getLineNoticeEventId());

        emcService.sendCommonChannelMsg(message.getLocale(), msgJson);
    }

    private JSONObject buildTaskUrgeButtonsMsg(String text, String url, String buttonName, String altText) {
        JSONObject taskUrgeMsg = new JSONObject();
        taskUrgeMsg.put("text", text);
        taskUrgeMsg.put("url", url);
        taskUrgeMsg.put("buttonName", buttonName);
        taskUrgeMsg.put("altText", altText);
        return taskUrgeMsg;
    }


}
