package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageTemplateDTO;
import com.digiwin.athena.aim.domain.message.repository.MessageTemplateMapper;
import com.digiwin.athena.aim.domain.message.service.MessageTemplateService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * MessageTemplateServiceImpl Description
 *
 * @author sungqz
 * @date 2023/9/18
 * @since
 */
@Slf4j
@Service
public class MessageTemplateServiceImpl implements MessageTemplateService {

    @Autowired
    private MessageTemplateMapper messageTemplateMapper;

    /**
     * 新增模板
     *
     * @param messageTemplateDTO 模板对象
     */
    @Override
    public MessageTemplateDTO insertMessageTemplate(MessageTemplateDTO messageTemplateDTO) {
        return messageTemplateMapper.insertMessageTemplate(messageTemplateDTO);
    }

    /**
     * 查询模板列表
     *
     * @param templateCode 模板code
     * @return
     */
    @Override
    public List<MessageTemplateDTO> queryMessageTemplateList(String templateCode) {
        return messageTemplateMapper.queryMessageTemplateList(templateCode);

    }

    private MessageDO buildQryMessageDO() {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        MessageDO condition = new MessageDO();
        condition.setUserId(user.getUserId());
        condition.setTenantId(user.getTenantId());
        return condition;
    }
}