package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.infrastructure.mongo.AbstractMongoMessageMapper;
import com.digiwin.athena.aim.domain.message.service.MiscHandleService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.text.MessageFormat;

@Slf4j
@Service("miscHandleServiceImpl")
public class MiscHandleServiceImpl extends AbstractMongoMessageMapper implements MiscHandleService {

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 租户前缀
     */
    private static final String TENANT_ID_PREFIX = "digidemo";

    /**
     * 录制租户前缀
     */
    private static final String RECORD_TENANT_ID_PREFIX = "digir";

    /**
     * 重置租户前缀
     */
    private static final String CREATE_TENANT_ID_PREFIX = "digid";

    /**
     * 按指定的租户清除附件数据
     */
    public void resetDataByTenantId(){

        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();

        if(StringUtils.isEmpty(user.getTenantId())){
            throw BusinessException.create(messageUtils.getMessage("exception.tenant.empty"));
        }

        if(!StringUtils.startsWithIgnoreCase(user.getTenantId(), RECORD_TENANT_ID_PREFIX)
                && !StringUtils.startsWithIgnoreCase(user.getTenantId(), CREATE_TENANT_ID_PREFIX)
                && !StringUtils.startsWithIgnoreCase(user.getTenantId(), TENANT_ID_PREFIX)){
            throw BusinessException.create(MessageFormat.format(messageUtils.getMessage("exception.tenant.error"), user.getTenantId()));
        }

        String collectionName = getCollectionName(user.getTenantId());
        msgMongoTemplate.dropCollection(collectionName);

    }


    /**
     * 根据租户id删除消息
     * @param tenantId tenantId
     */
    public void deleteByTenantId(String tenantId)
    {
        if(StringUtils.isEmpty(tenantId)){
            throw BusinessException.create(messageUtils.getMessage("exception.tenant.error"));
        }
        String collectionName = getCollectionName(tenantId);
        msgMongoTemplate.dropCollection(collectionName);
    }

}
