package com.digiwin.athena.aim.domain.message.subscriber;

import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.athena.aim.common.TenantRouteTypeEnum;
import com.digiwin.athena.aim.domain.message.model.TenantRouteChangeMessageDO;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.aim.domain.tenantroute.service.TenantRouteService;
import com.digiwin.athena.appcore.util.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/10/28 16:07
 */
@Slf4j
public class ApolloConfigChangeSubscriber implements ConfigChangeListener {

    private final TenantRouteService tenantRouteService;

    private final MessageSendService messageSendService;

    private final String deployId;

    public ApolloConfigChangeSubscriber(String deployId) {
        this.tenantRouteService = SpringUtil.getBean(TenantRouteService.class);
        this.messageSendService = SpringUtil.getBean(MessageSendService.class);
        this.deployId = deployId;
    }

    //监听租户路由列表变更
    @Override
    public void onChange(ConfigChangeEvent changeEvent) {
        Set<String> changeKeys = changeEvent.changedKeys();
        Set<String> changeTenant = new HashSet<>();
        for (String key : changeKeys) {
            ConfigChange change = changeEvent.getChange(key);
            String oldValue = change.getOldValue();
            String newValue = change.getNewValue();
            if (StringUtils.isBlank(oldValue) && StringUtils.isBlank(newValue)) {
                continue;
            } else if (StringUtils.isBlank(oldValue) && StringUtils.isNotBlank(newValue)) {
                addAllTenants(changeTenant, newValue);
            } else if (StringUtils.isNotBlank(oldValue) && StringUtils.isBlank(newValue)) {
                addAllTenants(changeTenant, oldValue);
            }  else {
                String[] oldTenants = StringUtils.split(oldValue, ",");
                String[] newTenants = StringUtils.split(newValue, ",");
                changeTenant.addAll(diff(oldTenants, newTenants));
            }
        }
        changeTenant.forEach(tenant -> {
            Pair<TenantRouteTypeEnum, String> type = tenantRouteService.getRouteType(tenant, deployId);
            TenantRouteChangeMessageDO messageDO = new TenantRouteChangeMessageDO(tenant, getRouteType(type));
            try {
                messageSendService.sendTenantRouteChange(tenant, deployId, messageDO);
            } catch (Exception e) {
                log.error("发送消息给租户:{}、app:{}异常", tenant, deployId, e);
            }
        });
    }

    private String getRouteType(Pair<TenantRouteTypeEnum, String> type) {
        if (TenantRouteTypeEnum.PRE.equals(type.getLeft())) {
            return TenantRouteTypeEnum.PRE.name() + "-" + type.getValue();
        }
        return type.getLeft().name();
    }

    private void addAllTenants(Set<String> changeTenant, String tenantConcats) {
        String[] tenants = StringUtils.split(tenantConcats, ",");
        for (String tenant : tenants) {
            changeTenant.add(tenant);
        }
    }

    private Set<String> diff(String[] first, String[] second) {
        Map<String, Integer> firstMap = new HashMap<>();
        for (String firstVal : first) {
            firstMap.put(firstVal, 1);
        }
        Set<String> different = new HashSet<>();
        Set<String> secondSet = new HashSet<>();
        for (String secondVal : second) {
            secondSet.add(secondVal);
        }
        secondSet.forEach(secondVal -> {
            if (firstMap.containsKey(secondVal)) {
                firstMap.remove(secondVal);
            } else {
                different.add(secondVal);
            }
        });
        firstMap.forEach((k, v) -> {
            different.add(k);
        });
        return different;
    }
}
