package com.digiwin.athena.aim.domain.message.subscriber;

import com.google.common.eventbus.Subscribe;

import com.digiwin.athena.aim.domain.message.event.DingDingMessageEvent;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.service.DingDingMessageService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * NoticeMobileAppSubscriber Description
 *
 * @author majianfu
 * @date 2021/7/24
 * @since
 */
@Component
@Slf4j
public class DingDingMessageSubscriber {
    @Resource
    private DingDingMessageService dingDingMessageService;

    @Subscribe
    public void handle(DingDingMessageEvent event) {
        if (MapUtils.isNotEmpty(event.getMdcContext())){
            MDC.setContextMap(event.getMdcContext());
        }
        log.info("senDingDingMessage 【钉钉发送消息event】：{}", CollectionUtils.isNotEmpty(event.getMessageBatchUserList()) ? event.getMessageBatchUserList().size() : 0);
        long start = System.currentTimeMillis();
        try {
            for (MessageBatchUserDTO message : event.getMessageBatchUserList()) {
                dingDingMessageService.senDingDingMessage(message);
            }
        } catch (Exception ex) {
            log.error("[senDingDingMessage] error: {}", ex);
        }
        finally {
            log.info("senDingDingMessage结束时间：{}",System.currentTimeMillis()-start);
            try {
                if (MapUtils.isNotEmpty(event.getMdcContext())) {
                    MDC.clear();
                }
            } catch (Exception e) {
                log.error("logMdcRemoveEx", e);
            }
        }
    }



}
