package com.digiwin.athena.aim.domain.message.subscriber;

import com.google.common.eventbus.Subscribe;

import com.digiwin.athena.aim.domain.message.event.LineMessageEvent;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.service.LineMessageService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * line消息事件订阅
 *
 * @author hujun
 * @since 2025年1月14日 16:50:13
 */
@Component
@Slf4j
public class LineMessageSubscriber {
    @Resource
    private LineMessageService lineMessageService;

    @Subscribe
    public void handle(LineMessageEvent event) {
        if (MapUtils.isNotEmpty(event.getMdcContext())) {
            MDC.setContextMap(event.getMdcContext());
        }
        log.info("send line message event：{}", CollectionUtils.isNotEmpty(event.getMessageBatchUserList()) ? event.getMessageBatchUserList().size() : 0);
        long start = System.currentTimeMillis();
        try {
            for (MessageBatchUserDTO message : event.getMessageBatchUserList()) {
                // 判断是否发送line
                lineMessageService.sendLineMessage(message);
            }
        } catch (Exception ex) {
            log.error("send line message occur error", ex);
        } finally {
            log.info("send line message event结束时间：{}", System.currentTimeMillis() - start);
            try {
                if (MapUtils.isNotEmpty(event.getMdcContext())) {
                    MDC.clear();
                }
            } catch (Exception e) {
                log.error("logMdcRemoveEx", e);
            }
        }
    }
}
