package com.digiwin.athena.aim.domain.message.subscriber;

import com.google.common.eventbus.Subscribe;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.domain.message.event.NoticeMobileAppEvent;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.infrastructure.mobile.AppSendMsgService;
import com.digiwin.athena.aim.infrastructure.mobile.MobileProperties;

import net.sf.json.JSONObject;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

import java.util.Optional;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * NoticeMobileAppSubscriber Description
 *
 * @author majianfu
 * @date 2021/7/24
 * @since
 */
@Component
@Slf4j
public class NoticeMobileAppSubscriber {
    @Resource
    private AppSendMsgService appSendMsgService;

    @Resource
    private EnvProperties envProperties;

    @Subscribe
    public void handle(NoticeMobileAppEvent event) {
        if (MapUtils.isNotEmpty(event.getMdcContext())) {
            MDC.setContextMap(event.getMdcContext());
        }
        log.info("【移动端消息提醒event】：{}",event.getMessageList());
        log.info("【移动端消息提醒needNoticeMobileApp】：{}",!needNoticeMobileApp());
        long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(event.getMessageList()) || !needNoticeMobileApp()) {
            return;
        }

        try {
            for (MessageDO message : event.getMessageList()) {
                JSONObject mobileAppMsg = message.convertMobileAppMsg();
                appSendMsgService.sendAppMsg(mobileAppMsg);
            }
        } catch (Exception ex) {
            // 吃掉异常
            log.error("[NoticeMobileAppSubscriber] error: {}", ex.getMessage(), ex);
        } finally {
            log.info("移动端消息提醒event结束时间：{}", System.currentTimeMillis() - start);
            try {
                if (MapUtils.isNotEmpty(event.getMdcContext())) {
                    MDC.clear();
                }
            } catch (Exception e) {
                log.error("logMdcRemoveEx", e);
            }
        }
    }

    private boolean needNoticeMobileApp() {
        // 配置了mobile.message.uri，则认为需要通知移动端APP
        Optional<String> sendMsgUri = Optional.ofNullable(envProperties.getMobileProperties())
                .map(MobileProperties::getMessage)
                .map(MobileProperties.MessageProperties::getUri);
        log.info("【移动端消息提醒sendMsgUri】：{}",sendMsgUri);
        return sendMsgUri.isPresent() && StringUtils.isNotBlank(sendMsgUri.get());
    }


}
