package com.digiwin.athena.aim.domain.tenantroute.service;

import com.digiwin.athena.aim.api.dto.GrayTenantDTO;
import com.digiwin.athena.aim.common.TenantRouteTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/10/28 16:52
 */
public interface TenantRouteService {

    String NAMESPACE_SPLITOR = "_";

    String TENANT_SPLITOR = ",";

    String AR_NAMESPACE_SUFFIX = NAMESPACE_SPLITOR + "ar";

    String TR_NAMESPACE_SUFFIX = NAMESPACE_SPLITOR + "tr";

    /**
     * 获取租户当前app路由类型
     *
     * @param tenantId
     * @param depolyId 部署专案id
     * @return
     */
    Pair<TenantRouteTypeEnum, String> getRouteType(String tenantId, String depolyId);

    /**
     * @param
     * @return
     * @description: 查询组件配置的所有的预区租户id集合
     * @author: sunyfa
     */
    List<String> queryPreEnvTenantIdList(String deployId);

    /**
     * 询组件配置的所在的预区租户id集合
     *
     * @param app
     * @param mode
     * @return
     */
    GrayTenantDTO queryResolveEnvTenantIdList(String app, String mode);
}
