package com.digiwin.athena.aim.domain.tenantroute.service.impl;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.athena.aim.api.dto.GrayTenantDTO;
import com.digiwin.athena.aim.app.config.TenantRouteNamepspaceConfig;
import com.digiwin.athena.aim.common.TenantRouteTypeEnum;
import com.digiwin.athena.aim.domain.tenantroute.service.TenantRouteService;
import com.digiwin.athena.appcore.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/10/28 16:52
 */
@Slf4j
@Service
public class TenantRouteServiceImpl implements TenantRouteService {

    @Autowired
    private TenantRouteNamepspaceConfig tenantRouteNamepspaceConfig;

    @Override
    public Pair<TenantRouteTypeEnum, String> getRouteType(String tenantId, String depolyId) {
        log.info("租户{}获取应用{}是否是预区路由", tenantId, depolyId);
        String mmcId = tenantRouteNamepspaceConfig.getMmcIdByDeployId(depolyId);
        if (mmcId == null) {
            throw BusinessException.create("部署id传入有误");
        }
        String arNamespace = mmcId + AR_NAMESPACE_SUFFIX;
        Config arConfig = ConfigService.getConfig(arNamespace);
        String arKey = tenantRouteNamepspaceConfig.getArKeyByDeployId(depolyId);
        String arValue = arConfig.getProperty(arKey, null);
        if (StringUtils.isBlank(arValue)) {
            log.warn("namespace:{}配置value为空", arNamespace);
            return Pair.of(TenantRouteTypeEnum.PROD, arValue);
        }
        String trNamespace = mmcId + NAMESPACE_SPLITOR + arKey + TR_NAMESPACE_SUFFIX;
        Config trConfig = ConfigService.getConfig(trNamespace);
        Set<String> trKeys = trConfig.getPropertyNames();
        if (CollectionUtils.isEmpty(trKeys)) {
            log.warn("namespace:{}配置为空", trNamespace);
            return Pair.of(TenantRouteTypeEnum.PROD, arValue);
        }
        List<String> preTrKeys = trKeys.stream().filter(one -> !arValue.equals(one)).collect(Collectors.toList());
        String tenantWithSplitor = TENANT_SPLITOR + tenantId + TENANT_SPLITOR;
        for (String preTrKey : preTrKeys) {
            String trValue = trConfig.getProperty(preTrKey, null);
            if (StringUtils.isBlank(trValue)) {
                continue;
            }
            if ((TENANT_SPLITOR + trValue + TENANT_SPLITOR).contains(tenantWithSplitor)) {
                log.warn("租户配置在预区路由");
                return Pair.of(TenantRouteTypeEnum.PRE, preTrKey);
            }
        }
        log.warn("租户没有配置在预区路由");
        return Pair.of(TenantRouteTypeEnum.PROD, arValue);
    }

    @Override
    public List<String> queryPreEnvTenantIdList(String deployId) {
        String mmcId = tenantRouteNamepspaceConfig.getMmcIdByDeployId(deployId);
        if (mmcId == null) {
            throw BusinessException.create("部署id传入有误");
        }
        log.info("mmcId:{}", mmcId);

        List<String> preEnvTenantIdList = new ArrayList<>();

        String arNamespace = mmcId + AR_NAMESPACE_SUFFIX;
        Config arConfig = ConfigService.getConfig(arNamespace);
        String arKey = tenantRouteNamepspaceConfig.getArKeyByDeployId(deployId);
        log.info("arKey:{}", arKey);

        String arValue = arConfig.getProperty(arKey, null);
        if (StringUtils.isBlank(arValue)) {
            log.warn("namespace:{}配置value为空", arNamespace);
            return preEnvTenantIdList;
        }
        String trNamespace = mmcId + NAMESPACE_SPLITOR + arKey + TR_NAMESPACE_SUFFIX;
        Config trConfig = ConfigService.getConfig(trNamespace);
        Set<String> trKeys = trConfig.getPropertyNames();
        log.info("trKeys:{}", trKeys);

        if (CollectionUtils.isEmpty(trKeys)) {
            log.warn("namespace:{}配置为空", trNamespace);
            return preEnvTenantIdList;
        }
        List<String> preTrKeys = trKeys.stream().filter(one -> !arValue.equals(one)).collect(Collectors.toList());

        for (String preTrKey : preTrKeys) {
            String trValue = trConfig.getProperty(preTrKey, null);
            if (StringUtils.isBlank(trValue)) {
                continue;
            }

            preEnvTenantIdList.add(trValue);
        }
        return preEnvTenantIdList;
    }

    @Override
    public GrayTenantDTO queryResolveEnvTenantIdList(String app, String mode) {
        String mmcId = tenantRouteNamepspaceConfig.getMmcIdByDeployId(app);
        if (mmcId == null) {
            throw BusinessException.create("部署id:" + app + "传入有误");
        }

        String arKey = tenantRouteNamepspaceConfig.getArKeyByDeployId(app);
        log.info("queryResolveEnvTenantIdList app:{},mode:{},mmcId:{},arKey:{}", app, mode, mmcId, arKey);

        String arNamespace = mmcId + AR_NAMESPACE_SUFFIX;
        Config arConfig = ConfigService.getConfig(arNamespace);
        String arValue = arConfig.getProperty(arKey, null);

        GrayTenantDTO grayTenantDTO = new GrayTenantDTO();
        grayTenantDTO.setMaster(false);
        List<String> preEnvTenantIdList = new ArrayList<>();
        if (StringUtils.isBlank(arValue)) {
            log.warn("queryResolveEnvTenantIdList namespace:{} 配置value为空", arNamespace);
            grayTenantDTO.setTenantIdList(preEnvTenantIdList);
            return grayTenantDTO;
        }
        log.info("queryResolveEnvTenantIdList arValue:{},mode:{}", arValue, mode);
        if (arValue.equals(mode)) {
            grayTenantDTO.setMaster(true);
        }
        String trNamespace = mmcId + NAMESPACE_SPLITOR + arKey + TR_NAMESPACE_SUFFIX;
        Config trConfig = ConfigService.getConfig(trNamespace);
        Set<String> trKeys = trConfig.getPropertyNames();
        log.info("queryResolveEnvTenantIdList trKeys:{}", trKeys);

        if (CollectionUtils.isEmpty(trKeys)) {
            log.warn("queryResolveEnvTenantIdList namespace:{}配置为空", trNamespace);
            grayTenantDTO.setTenantIdList(preEnvTenantIdList);
            return grayTenantDTO;
        }
        //如果是生产，则返回所有，反之则返回自身
        List<String> preTrKeys;
        if (arValue.equals(mode)) {
            preTrKeys = new ArrayList<>(trKeys);
        } else {
            preTrKeys = Arrays.asList(mode);
        }

        for (String preTrKey : preTrKeys) {
            String trValue = trConfig.getProperty(preTrKey, null);
            if (StringUtils.isBlank(trValue)) {
                continue;
            }
            preEnvTenantIdList.add(trValue);
        }
        grayTenantDTO.setTenantIdList(preEnvTenantIdList);
        return grayTenantDTO;
    }
}
