package com.digiwin.athena.aim.infrastructure.atmc.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.Constants;
import com.digiwin.athena.aim.common.InterfaceConstant;
import com.digiwin.athena.aim.infrastructure.atmc.AtmcService;
import com.digiwin.athena.aim.infrastructure.thememap.dto.IamDdMessageDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @program: emc
 */
@Slf4j
@Service
public class AtmcServiceImpl implements AtmcService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;


    @Override
    public String getShareCode(String taskId, String taskType) {
        String url = envProperties.getAtmcUri() + InterfaceConstant.ATMC_SHARE_API;
        url = String.format(url, taskType, taskId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject(this);
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(reqObject, headers);
        try {
            log.info("请求ATMC获取分享码 入参:{}", JsonUtils.objectToString(httpEntity));
            ResponseEntity<BaseResultDTO<String>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<String>>() {
                    });
            log.info("请求ATMC获取分享码，入参url：{}, 响应内容：{}", url, respEntity.getBody().getResponse());
            if (null != respEntity.getBody() && respEntity.getBody().isOK()) {
                return respEntity.getBody().getResponse();
            }
        } catch (BusinessException ex) {
            log.error("请求ATMC获取分享码报错，入参url：{}, ex：{}", url, ex);
        }
        return "";
    }

}

