package com.digiwin.athena.aim.infrastructure.concurrent.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jugg.agile.framework.core.config.JaProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 自定义默认动态线程池<br></>
 * 如不采用默认，可以参考该类自己实现
 */
@Slf4j
@Component
public class DynamicThreadPool extends AbstractDynamicThreadPool {

    @Autowired
    private DynamicThreadPoolConfig dynamicThreadPoolConfig;

    private final String poolName = "dynamicThreadPool";

    @Override
    protected DynamicThreadPoolBean buildThreadPool() {
        DynamicThreadPoolBean dynamicThreadPool = new DynamicThreadPoolBean(poolName, dynamicThreadPoolConfig.getCoreSize(), dynamicThreadPoolConfig.getMaxSize(), dynamicThreadPoolConfig.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<>(dynamicThreadPoolConfig.getQueueSize()), new ThreadFactoryBuilder().setNameFormat(poolName + "_%d").build(), new ThreadPoolExecutor.CallerRunsPolicy(), dynamicThreadPoolConfig.getQueueSize());
        return dynamicThreadPool;
    }

    /**
     * 该方法会实时接收到变更推送<br></>
     * 可以根据nacos配置属性获取最新的值，用于变更线程池配置
     *
     * @return
     */
    @Override
    public DynamicParam transferParameter() {
        Integer coreSize = JaProperty.getInteger(DynamicThreadPoolConstant.DYNAMIC_THREADPOOL_CORESIZE, dynamicThreadPoolConfig.getCoreSize());
        Integer maxSize = JaProperty.getInteger(DynamicThreadPoolConstant.DYNAMIC_THREADPOOL_MAXSIZE, dynamicThreadPoolConfig.getMaxSize());
        DynamicParam dynamicParam = new DynamicParam(coreSize, maxSize);
        return dynamicParam;
    }
}