package com.digiwin.athena.aim.infrastructure.concurrent.pool;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 线程池配置
 */
@Data
@Component
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "dynamic.thread-pool")
public class DynamicThreadPoolConfig {

    //核心线程数
    @Value("${dynamic.threadPool.coreSize:30}")
    private Integer coreSize;

    //最大线程数
    @Value("${dynamic.threadPool.maxSize:200}")
    private Integer maxSize;

    @Value("${dynamic.threadPool.keepAliveTime:60}")
    //线程空闲时间
    private Long keepAliveTime;

    //队列大小
    @Value("${dynamic.threadPool.queueSize:1000}")
    private Integer queueSize;

    //超时时间
    private Long timeOut;

    // 默认超时时间
    private static final Long DEFAULT_TIMEOUT = 60000L;

    @PostConstruct
    public void init() {
        if (timeOut==null) {
            timeOut = DEFAULT_TIMEOUT;
        }
    }
}
