package com.digiwin.athena.aim.infrastructure.dingding.impl;

import com.digiwin.athena.aim.infrastructure.dingding.DingdingService;
import com.digiwin.athena.aim.infrastructure.dingding.dto.DingdingInviteSettingDto;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import java.time.LocalDateTime;

import static com.digiwin.athena.aim.common.DingdingConstant.REMIND_SETTING_COLLECTION_NAME;

/**
 * @author lzw
 * @date 2024/6/21
 * @description:
 **/
@Slf4j
@Service
public class DingdingServiceImpl implements DingdingService {

    @Resource
    protected MongoTemplate mongoTemplate;

    /**
     * 存储邀请提醒设置
     * @param isNeverRemind
     * @param user
     */
    @Override
    public void recordInviteSetting(Boolean isNeverRemind, AuthoredUser user) {
        //组装集合名
        DingdingInviteSettingDto dto = buildDto(isNeverRemind,user);
        //存储
        if (Boolean.TRUE.equals(isNeverRemind)){
            mongoTemplate.insert(dto, REMIND_SETTING_COLLECTION_NAME);
        }else {
            //删除
            Query query = Query.query(Criteria.where("userId").is(user.getUserId()).and("tenantSid").is(user.getTenantSid()));
            mongoTemplate.remove(query,REMIND_SETTING_COLLECTION_NAME);
        }

    }

    /**
     * 获取邀请提醒设置
     * @param user
     * @return
     */
    @Override
    public ResponseEntity<?> getRemindSetting(AuthoredUser user) {
        Query query = Query.query(Criteria.where("userId").is(user.getUserId()).and("tenantSid").is(user.getTenantSid()));
        query.with(Sort.by(Sort.Direction.DESC, "createTime"));
        DingdingInviteSettingDto dto = mongoTemplate.findOne(query, DingdingInviteSettingDto.class, REMIND_SETTING_COLLECTION_NAME);
        if (dto == null || !Boolean.TRUE.equals(dto.getIsNeverRemind())){
            //未设置不再提醒
            return ResponseEntityWrapper.wrapperOk(false);
        }
        //设置了不再提醒
        return ResponseEntityWrapper.wrapperOk(true);
    }

    private DingdingInviteSettingDto buildDto(Boolean isNeverRemind, AuthoredUser user) {
        DingdingInviteSettingDto dto = new DingdingInviteSettingDto();
        dto.setIsNeverRemind(isNeverRemind);
        dto.setUserId(user.getUserId());
        dto.setTenantSid(user.getTenantSid());
        dto.setCreateTime(LocalDateTime.now());
        return dto;
    }

}
