package com.digiwin.athena.aim.infrastructure.emc;

import com.digiwin.athena.aim.domain.message.model.MessageCenterConfigDTO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterTenantChannelConfig;
import com.digiwin.athena.aim.infrastructure.thememap.dto.IamDdMessageDTO;
import net.sf.json.JSONObject;
import org.springframework.http.ResponseEntity;

import java.util.List;
import java.util.Map;

public interface EmcService {

    /**
     * 发送钉钉消息
     * @param iamDdMessageDTO
     * @return
     */
    int senDdMessage(IamDdMessageDTO iamDdMessageDTO);

    /**
     * 发送企微消息
     *
     * @param userIdList 消息发送用户列表
     * @param msg 消息内容
     * @return 返回对象
     */
    void sendWeChat(List<String> userIdList, String msg, String appId);

    /**
     * 各渠道发送消息
     *
     * @param language 语系
     * @param msgJson 消息体
     */
    void sendCommonChannelMsg(String language, JSONObject msgJson);

    /**
     * 发送模板邮件，要发送的邮件内容已组装好
     *
     * @param content 邮件内容
     */
    void sendEmail(String language, JSONObject content);

    /**
     * 根据场景id获取场景配置
     * @param tenantId
     * @param appCode
     * @param sceneId
     * @return
     */
    List<MessageCenterConfigDTO> getMsgConfigList(String tenantId, String appCode, String sceneId);

    /**
     * 查询租户级场景渠道配置
     * @return
     */
    List<MessageCenterTenantChannelConfig> getMsgTenantChannelConfigList();

    /**
     * 查询钉钉内部应用配置
     * @param param
     * @return
     */
    Map getAppConfig(JSONObject param);


    /**
     * 查询微信配置
     * @return
     */
    ResponseEntity<JSONObject> getWecomConfig();

}
