package com.digiwin.athena.aim.infrastructure.eoc.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.InterfaceConstant;
import com.digiwin.athena.aim.infrastructure.eoc.EocService;
import com.digiwin.athena.aim.infrastructure.eoc.dto.EmpDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class EocServiceImpl implements EocService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public List<EmpDTO> getEmpByIds(List<String> userIds, List<String> empIds) {

        String uri = envProperties.getEocUri() + InterfaceConstant.EOC_GET_EMP_INFOS;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());

        Map<String, Object> param = new HashMap<>();
        param.put("userIds", userIds);
        param.put("empIds", empIds);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        try {
            log.info("[getEmpByIds]请求EOC 查询员工信息 入参:userIds = {}, empIds = {}", userIds, empIds);
            ResponseEntity<IamResultDTO<List<EmpDTO>>> respEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<IamResultDTO<List<EmpDTO>>>() {
            }, param);
            if (null != respEntity.getBody() && respEntity.getBody().getSuccess()) {
                return respEntity.getBody().data();
            }
        } catch (Exception e) {
            log.info("[getEmpByIds]请求EOC 查询员工信息失败 入参:userIds = {}, empIds = {},e = {}", userIds, empIds, e);
        }
        return new ArrayList<>();
    }

    @Override
    public List<EmpDTO> getEmpByDutyIds(List<String> dutyIds) {

        String uri = envProperties.getEocUri() + InterfaceConstant.EOC_GET_EMP_INFOS_BY_DUTY;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());

        Map params = new HashMap();
        params.put("dutyIds", String.join(",",dutyIds));
        try {
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        log.info("[getEmpByIds]请求EOC 查询员工信息 入参:dutyIds = {}", dutyIds);
        ResponseEntity<IamResultDTO<List<EmpDTO>>> respEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<IamResultDTO<List<EmpDTO>>>() {
        }, params);

            if (null != respEntity.getBody() && respEntity.getBody().getSuccess()) {
                return respEntity.getBody().data();
            }
        } catch (Exception e) {
            log.info("[getEmpByIds]请求EOC 查询员工信息失败 入参:dutyIds = {},e = {}", dutyIds, e);
        }
        return new ArrayList<>();
    }
}
