package com.digiwin.athena.aim.infrastructure.iam;

import com.digiwin.athena.aim.infrastructure.iam.dto.IamUserDTO;
import com.digiwin.athena.aim.infrastructure.iam.dto.IamUserTokenDTO;
import com.digiwin.athena.aim.infrastructure.iam.dto.PersonalizedDto;

import java.util.List;
import java.util.Map;

public interface IamService {
    List<IamUserDTO> getUserListByRole(String roleId);

    /**
     *
     * @param userId
     * @param type   1是语言别  2是line 3是钉钉
     * @param lineOrDingding
     * @return
     */
    String getUserMetadataAllTenant(String userId, int type,int lineOrDingding);

    /**
     * 批量获取用户临时token
     *
     * @param userIdList 用户列表
     * @return 返回对象
     */
    List<IamUserTokenDTO> queryUserTempToken(List<IamUserTokenDTO> userIdList);

    /**
     * 批量获取用户信息
     *
     * @param userIdList 用户列表
     * @return 返回对象
     */
    List<IamUserDTO> queryUserInfoList(List<String> userIdList);

    /**
     * 获取租户的钉钉corpid
     * @return
     */
    String getTenantCorpid();

    /**
     * 批量获取用户信息
     *
     * @param userIdList 用户列表
     * @return 返回对象
     */
    List<PersonalizedDto> queryUserMetadataList(List<String> userIdList);

    /**
     *  批量获取多语言信息
     * @param userIdList
     * @return
     */
    List<PersonalizedDto> queryUserLangMetadataList(List<String> userIdList);
}
