package com.digiwin.athena.aim.infrastructure.mobile;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * MobileProperties Description
 *
 * @author majianfu
 * @date 2021/7/23
 * @since
 */

@Data
@Component
@JsonIgnoreProperties("$$beanFactory")
@ConfigurationProperties(prefix = "mobile", ignoreInvalidFields = true)
public class MobileProperties {

    private String uri;

    private OauthProperties oauth;

    private MessageProperties message;

    @Data
    public static class MessageProperties {
        private String uri;
    }

    @Data
    public static class OauthProperties {
        private String uri;

        private String grantType;

        private String clientId;

        private String clientSecret;
    }
}
