package com.digiwin.athena.aim.infrastructure.mongo;

import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordDO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordReq;
import com.digiwin.athena.aim.domain.message.repository.MessageCenterMapper;
import com.digiwin.athena.aim.util.LanguageUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class MongoMessageCenterMapper extends AbstractMongoMessageMapper implements MessageCenterMapper {


    @Override
    public MessageCenterRecordDO insert(MessageCenterRecordDO messageCenterRecordDO) {

        // 获取集合名称
        String collectionName = getCollectionNameForMessageCenterRecord(messageCenterRecordDO.getTenantId());

        // 添加消息记录
        return msgMongoTemplate.insert(messageCenterRecordDO, collectionName);
    }

    @Override
    public PageImpl<MessageCenterRecordDO> pageMessageCenterRecord(MessageCenterRecordReq messageCenterSendReq) throws  IllegalAccessException {

        if (StringUtils.isEmpty(messageCenterSendReq.getTenantId()) || StringUtils.isEmpty(messageCenterSendReq.getAppCode()) || StringUtils.isEmpty(messageCenterSendReq.getChannelType())) {
            return new PageImpl<>(new ArrayList<>(), PageRequest.of(messageCenterSendReq.getPageNum(), messageCenterSendReq.getPageSize()), 0);
        }

        Criteria criteria = Criteria.where("tenantId").is(messageCenterSendReq.getTenantId())
                .and("appCode").is(messageCenterSendReq.getAppCode()).and("channelType").is(messageCenterSendReq.getChannelType());

        if (StringUtils.isNotBlank(messageCenterSendReq.getSceneName())) {
            String lang = LocaleContextHolder.getLocale().toString();
            criteria.and("lang.sceneName." + lang).regex(messageCenterSendReq.getSceneName());
        }
        if (StringUtils.isNotBlank(messageCenterSendReq.getReceiver())) {
            criteria.and("receivers").regex(messageCenterSendReq.getReceiver());
        }
        if (CollectionUtils.isNotEmpty(messageCenterSendReq.getMsgTypeList())){
            criteria.and("msgType").in(messageCenterSendReq.getMsgTypeList());
        }
        if (CollectionUtils.isNotEmpty(messageCenterSendReq.getStatuslist())){
            criteria.and("status").in(messageCenterSendReq.getStatuslist());
        }

        long count = countByCondition(getCollectionNameForMessageCenterRecord(messageCenterSendReq.getTenantId()), criteria, DEFAULT_LIMIT, ORDER_CREATETIME);
        Pageable pageable = PageRequest.of(messageCenterSendReq.getPageNum(), messageCenterSendReq.getPageSize());
        List<MessageCenterRecordDO> messageList = msgMongoTemplate.find(new Query().addCriteria(criteria).with(pageable).with(Sort.by(Sort.Direction.DESC, "createDate")),
                MessageCenterRecordDO.class,
                getCollectionNameForMessageCenterRecord(messageCenterSendReq.getTenantId()));

        LanguageUtil.processLocaleLanguage(messageList,LocaleContextHolder.getLocale().toString());

        return new PageImpl<>(messageList, pageable, count);
    }
}
