package com.digiwin.athena.aim.infrastructure.mongo;


import com.digiwin.athena.aim.domain.message.model.CiConstant;
import com.digiwin.athena.aim.domain.message.model.MessageTemplateDTO;
import com.digiwin.athena.aim.domain.message.repository.MessageTemplateMapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

/**
 * MongoMessageTemplateMapper Description
 *
 * @author sungqz
 * @date 2023/9/18
 * @since
 */
@Repository
public class MongoMessageTemplateMapper extends AbstractMongoMessageMapper implements MessageTemplateMapper {

    /**
     * 新增模板
     *
     * @param messageTemplateDTO 模板对象
     */
    @Override
    public MessageTemplateDTO insertMessageTemplate(MessageTemplateDTO messageTemplateDTO) {
        // 获取集合名称
        String collectionName = getCollectionNameForTempTemplate();
        // 在gid上创建索引
        createCollectionNecessary(collectionName, CiConstant.CollectionFlagEnum.TEMPLATE.getFlag());
        messageTemplateDTO.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
        messageTemplateDTO.setCreateDate(LocalDateTime.now());
        messageTemplateDTO.setModifyDate(LocalDateTime.now());
        messageTemplateDTO.setUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        messageTemplateDTO.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        // 添加模板
        return msgMongoTemplate.insert(messageTemplateDTO, collectionName);
    }

    /**
     * 查询模板列表
     *
     * @return
     */
    @Override
    public List<MessageTemplateDTO> queryMessageTemplateList(String templateCode) {
        // 获取集合名称
        String collectionName = getCollectionNameForTempTemplate();
        Query query = new Query();
        if (StringUtils.isNotBlank(templateCode)) {
            query.addCriteria(Criteria.where("code").is(templateCode));
        }
        return msgMongoTemplate.find(query.with(Sort.by(Sort.Direction.ASC, "createDate")),
                MessageTemplateDTO.class, collectionName);
    }
}
