package com.digiwin.athena.aim.infrastructure.mqtt.impl;
 ;
import com.digiwin.athena.aim.infrastructure.mqtt.MqSdk;
 import com.digiwin.athena.aim.infrastructure.mqtt.MqttProperties;
 import com.digiwin.athena.aim.infrastructure.mqtt.model.ClientListDTO;
import com.digiwin.athena.appcore.util.Base64Converter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.net.URI;

@Service
public class MqSdkImpl implements MqSdk {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MqttProperties mqttConfiguration;
//
//    @Override
//    public List<ExchangeBindingInfo> queryExchangeBindings(String exchangeName) {
//        String url = mqttConfiguration.getServerQueryUrl() +"api/exchanges/%2F/"+exchangeName+"/bindings/source";
//        //basic auth
//        String base64 = Base64Converter.encode(String.format("%s:%s",mqttConfiguration.getUsername(),mqttConfiguration.getPassword()));
//        HttpHeaders httpHeaders = new HttpHeaders();
//        httpHeaders.add("Authorization","Basic "+base64);
//        httpHeaders.add("content-type","application/json");
//        HttpEntity<MultiValueMap<String,Object>> httpEntity = new HttpEntity<>(null,httpHeaders);
//        ParameterizedTypeReference<List<ExchangeBindingInfo>> responseType = new ParameterizedTypeReference<List<ExchangeBindingInfo>>() {};
//        ResponseEntity<List<ExchangeBindingInfo>> result = restTemplate.exchange(URI.create(url), HttpMethod.GET,httpEntity,responseType);
//        return result.getBody();
//    }
    /**
     * 获取队列信息
     * @param filterName 过滤的文本
     * @param page 第几页
     * @param pageSize 每页大小
     * @return 队列信息
     */
    public ClientListDTO queryQueues(String filterName, int page, int pageSize){
        String url = String.format("%s/api/v4/clients?_like_clientid=%s&_page=%s&_limit=%s",
                mqttConfiguration.getServerQueryUrl(),filterName, page,pageSize);
        //basic auth
        String base64 = Base64Converter.encode(String.format("%s:%s",mqttConfiguration.getServerQueryUsername(),mqttConfiguration.getServerQueryPassword()));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization","Basic "+base64);
        httpHeaders.add("content-type","application/json");
        HttpEntity<MultiValueMap<String,Object>> httpEntity = new HttpEntity<>(null,httpHeaders);
        ParameterizedTypeReference<ClientListDTO> responseType = new ParameterizedTypeReference<ClientListDTO>() {};
        ResponseEntity<ClientListDTO> result = restTemplate.exchange(URI.create(url), HttpMethod.GET,httpEntity,responseType);
        return result.getBody();
    }
}
