package com.digiwin.athena.aim.infrastructure.semc;

import com.digiwin.athena.aim.infrastructure.semc.dto.*;

import java.util.List;

/**
 * semc service
 *
 * @author sungqz
 * @since 2023-12-4
 */
public interface SemcService {

    /**
     * 查询租户设置的消息发送渠道
     *
     * @return 渠道
     */
    String queryMessageChannel(String tenantId);

    /**
     * 查询各渠道模板信息
     *
     * @param channelFlag 渠道标识 email:邮件 sms:短信 wecom:企微 dingTalk:钉钉
     * @param eventId 事件id
     * @param remark  事件备注
     * @param tenantId 租户id
     * @return 对象
     */
    List<QueryTemplateListResp> queryTemplateList(String channelFlag, String eventId, String remark, String tenantId);

    /**
     * 查看模板接收人
     *
     * @param tenantId 租户id
     * @param eventId 事件id
     * @param channelFlag 渠道标识 email:邮件 sms:短信 wecom:企微 dingTalk:钉钉
     * @param language 语系 简体：zh-CN 繁体：zh-TW 英文：en-US
     * @return 返回对象
     */
    QueryTemplateRelResp queryRelPerson(String tenantId, String eventId, String channelFlag, String templateId, String language);

    /**
     * 查询黑白名单用户id
     *
     * @param tenantId 租户id
     * @param type 名单类型 0:黑名单 1:白名单
     * @param key  搜索关键字
     * @return 返回对象
     */
   List<QueryBlackWhiteListResp> queryBlackWhiteUserList(String tenantId, Integer type, String key);

    /**
     * 获取SSO url
     *
     * @param req
     * @return 返回对象
     */
    GetSsoUrlResp getSsoUrl(GetSsoUrlReq req);
}
