package com.digiwin.athena.aim.infrastructure.semc.dto;

import lombok.Data;

import java.util.List;


/**
 * 查询各个渠道列表 返回对象
 *
 * @author sungqz
 * @since 2024-01-17
 */
@Data
public class QueryTemplateListResp {

    /**
     * 主键ID
     */
    private String id;

    /**
     * om平台事件id
     */
    private String eventId;

    /**
     * 模板名称，om平台事件名称
     */
    private String name;

    /**
     * 模板备注，om平台事件备注
     */
    private String remark;

    /**
     * 模板状态 0:停用 1:启用
     */
    private Integer validStatus;

    /**
     * 渠道标识 email:邮件 sms:短信 wecom:企微 dingTalk:钉钉
     */
    private String channelFlag;

    /**
     * 修改者账号
     */
    private String modifyUserId;

    /**
     * 更新者名称
     */
    private String modifyUserName;

    /**
     * 修改日期
     */
    private String modifyTime;

    /**
     * 渠道列表
     */
    private List<OmEventTemplateDTO> templateList;
}